/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/binding/SimpleBinding.as
 * org.apache.flex.binding.SimpleBinding
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.binding.SimpleBinding');

goog.require('org.apache.flex.events.ValueChangeEvent');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IDocument');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBead}
 * @implements {org.apache.flex.core.IDocument}
 */
org.apache.flex.binding.SimpleBinding = function() {
};


/**
 * @protected
 * @type {org.apache.flex.events.IEventDispatcher}
 */
org.apache.flex.binding.SimpleBinding.prototype.source;


/**
 * @protected
 * @type {Object}
 */
org.apache.flex.binding.SimpleBinding.prototype.document;


/**
 * @export
 * @type {Object}
 */
org.apache.flex.binding.SimpleBinding.prototype.destination;


/**
 * @export
 * @type {string}
 */
org.apache.flex.binding.SimpleBinding.prototype.sourceID;


/**
 * @export
 * @type {string}
 */
org.apache.flex.binding.SimpleBinding.prototype.sourcePropertyName;


/**
 * @export
 * @type {string}
 */
org.apache.flex.binding.SimpleBinding.prototype.eventName;


/**
 * @export
 * @type {string}
 */
org.apache.flex.binding.SimpleBinding.prototype.destinationPropertyName;


/**
 *  @copy org.apache.flex.core.IDocument#setDocument()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} document
 * @param {string=} id
 */
org.apache.flex.binding.SimpleBinding.prototype.setDocument = function(document, id) {
  id = typeof id !== 'undefined' ? id : null;
  this.document = document;
};


/**
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.binding.SimpleBinding.prototype.changeHandler = function(event) {
  if (event.type == org.apache.flex.events.ValueChangeEvent.VALUE_CHANGE) {
    var /** @type {org.apache.flex.events.ValueChangeEvent} */ vce = org.apache.flex.utils.Language.as(event, org.apache.flex.events.ValueChangeEvent);
    if (vce.propertyName != this.sourcePropertyName)
      return;
  }
  this.destination[this.destinationPropertyName] = this.source[this.sourcePropertyName];
};


/**
 * @private
 * @param {org.apache.flex.events.ValueChangeEvent} event
 */
org.apache.flex.binding.SimpleBinding.prototype.sourceChangeHandler = function(event) {
  if (event.propertyName != this.sourceID)
    return;
  if (this.source)
    this.source.removeEventListener(this.eventName, org.apache.flex.utils.Language.closure(this.changeHandler, this, 'changeHandler'));
  this.source = org.apache.flex.utils.Language.as(this.document[this.sourceID], org.apache.flex.events.IEventDispatcher);
  if (this.source) {
    this.source.addEventListener(this.eventName, org.apache.flex.utils.Language.closure(this.changeHandler, this, 'changeHandler'));
    this.destination[this.destinationPropertyName] = this.source[this.sourcePropertyName];
  }
};


Object.defineProperties(org.apache.flex.binding.SimpleBinding.prototype, /** @lends {org.apache.flex.binding.SimpleBinding.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.binding.SimpleBinding} */ function(value) {
  if (this.destination == null)
    this.destination = value;
  if (this.sourceID != null) {
    this.source = org.apache.flex.utils.Language.as(this.document[this.sourceID], org.apache.flex.events.IEventDispatcher);
    if (this.source == null) {
      this.document.addEventListener("valueChange", org.apache.flex.utils.Language.closure(this.sourceChangeHandler, this, 'sourceChangeHandler'));
      return;
    }
  }
  else
    this.source = org.apache.flex.utils.Language.as(this.document, org.apache.flex.events.IEventDispatcher);
  this.source.addEventListener(this.eventName, org.apache.flex.utils.Language.closure(this.changeHandler, this, 'changeHandler'));
  try {
    this.destination[this.destinationPropertyName] = this.source[this.sourcePropertyName];
  } catch (e) {
  }
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.binding.SimpleBinding.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'SimpleBinding', qName: 'org.apache.flex.binding.SimpleBinding'}], interfaces: [org.apache.flex.core.IBead, org.apache.flex.core.IDocument] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.binding.SimpleBinding', org.apache.flex.binding.SimpleBinding);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.binding.SimpleBinding.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'destination': { type: 'Object'},
        'sourceID': { type: 'String'},
        'sourcePropertyName': { type: 'String'},
        'eventName': { type: 'String'},
        'destinationPropertyName': { type: 'String'}
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.binding.SimpleBinding'}
      };
    },
    methods: function () {
      return {
        'SimpleBinding': { type: '', declaredBy: 'org.apache.flex.binding.SimpleBinding'},
        'setDocument': { type: 'void', declaredBy: 'org.apache.flex.binding.SimpleBinding'}
      };
    }
  };
};