/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/binding/GenericBinding.as
 * org.apache.flex.binding.GenericBinding
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.binding.GenericBinding');

goog.require('org.apache.flex.events.ValueChangeEvent');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IDocument');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBead}
 * @implements {org.apache.flex.core.IDocument}
 */
org.apache.flex.binding.GenericBinding = function() {
};


/**
 * @protected
 * @type {Object}
 */
org.apache.flex.binding.GenericBinding.prototype.document;


/**
 * @protected
 * @type {Object}
 */
org.apache.flex.binding.GenericBinding.prototype.destination;


/**
 * @export
 * @type {Object}
 */
org.apache.flex.binding.GenericBinding.prototype.source;


/**
 * @export
 * @type {Object}
 */
org.apache.flex.binding.GenericBinding.prototype.destinationData;


/**
 * @export
 * @type {Function}
 */
org.apache.flex.binding.GenericBinding.prototype.destinationFunction;


/**
 * @private
 * @return {Object}
 */
org.apache.flex.binding.GenericBinding.prototype.getValueFromSource = function() {
  if (org.apache.flex.utils.Language.is(this.source, Array)) {
    var /** @type {Array} */ arr = org.apache.flex.utils.Language.as(this.source, Array);
    var /** @type {number} */ n = arr.length;
    var /** @type {Object} */ obj = this.document[arr[0]];
    if (obj == null)
      return null;
    for (var /** @type {number} */ i = 1; i < n; i++) {
      obj = obj[arr[i]];
      if (obj == null)
        return null;
    }
    return obj;
  } else if (org.apache.flex.utils.Language.is(this.source, Function)) {
    var /** @type {Function} */ fn = org.apache.flex.utils.Language.as(this.source, Function);
    obj = fn.apply(this.document);
    return obj;
  } else if (org.apache.flex.utils.Language.is(this.source, String)) {
    obj = this.document[this.source];
    return obj;
  }
  return null;
};


/**
 * @private
 * @param {Object} value
 */
org.apache.flex.binding.GenericBinding.prototype.applyValue = function(value) {
  if (this.destinationFunction != null) {
    this.destinationFunction.apply(this.document, [value]);
  } else if (org.apache.flex.utils.Language.is(this.destinationData, Array)) {
    var /** @type {Array} */ arr = org.apache.flex.utils.Language.as(this.destinationData, Array);
    var /** @type {number} */ n = arr.length;
    var /** @type {Object} */ obj = this.document[arr[0]];
    if (obj == null) {
      this.document.addEventListener(org.apache.flex.events.ValueChangeEvent.VALUE_CHANGE, org.apache.flex.utils.Language.closure(this.destinationChangeHandler, this, 'destinationChangeHandler'));
      return;
    }
    for (var /** @type {number} */ i = 1; i < n - 1; i++) {
      obj = obj[arr[i]];
      if (obj == null)
        return;
    }
    obj[arr[n - 1]] = value;
  }
};


/**
 *  @copy org.apache.flex.core.IDocument#setDocument()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} document
 * @param {string=} id
 */
org.apache.flex.binding.GenericBinding.prototype.setDocument = function(document, id) {
  id = typeof id !== 'undefined' ? id : null;
  this.document = document;
};


/**
 *  The method that gets called by the watcher when the value
 *  may have changed.
 *
 *  @asparam value The new value.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} value
 */
org.apache.flex.binding.GenericBinding.prototype.valueChanged = function(value) {
  try {
    var /** @type {Object} */ val = this.getValueFromSource();
    this.applyValue(val);
  } catch (e) {
  }
};


/**
 * @private
 * @param {org.apache.flex.events.ValueChangeEvent} event
 */
org.apache.flex.binding.GenericBinding.prototype.destinationChangeHandler = function(event) {
  if (event.propertyName == this.destinationData[0])
    this.valueChanged(null);
};


Object.defineProperties(org.apache.flex.binding.GenericBinding.prototype, /** @lends {org.apache.flex.binding.GenericBinding.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.binding.GenericBinding} */ function(value) {
  this.destination = value;
  try {
    var /** @type {Object} */ val = this.getValueFromSource();
    this.applyValue(val);
  } catch (e) {
  }
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.binding.GenericBinding.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'GenericBinding', qName: 'org.apache.flex.binding.GenericBinding'}], interfaces: [org.apache.flex.core.IBead, org.apache.flex.core.IDocument] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.binding.GenericBinding', org.apache.flex.binding.GenericBinding);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.binding.GenericBinding.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'source': { type: 'Object'},
        'destinationData': { type: 'Object'},
        'destinationFunction': { type: 'Function'}
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.binding.GenericBinding'}
      };
    },
    methods: function () {
      return {
        'GenericBinding': { type: '', declaredBy: 'org.apache.flex.binding.GenericBinding'},
        'setDocument': { type: 'void', declaredBy: 'org.apache.flex.binding.GenericBinding'},
        'valueChanged': { type: 'void', declaredBy: 'org.apache.flex.binding.GenericBinding'}
      };
    }
  };
};