/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/binding/ChainBinding.as
 * org.apache.flex.binding.ChainBinding
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.binding.ChainBinding');

goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IDocument');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBead}
 * @implements {org.apache.flex.core.IDocument}
 */
org.apache.flex.binding.ChainBinding = function() {
};


/**
 * @export
 * @type {Array}
 */
org.apache.flex.binding.ChainBinding.prototype.source;


/**
 * @protected
 * @type {Object}
 */
org.apache.flex.binding.ChainBinding.prototype.document;


/**
 * @export
 * @type {Object}
 */
org.apache.flex.binding.ChainBinding.prototype.destination;


/**
 * @export
 * @type {Object}
 */
org.apache.flex.binding.ChainBinding.prototype.watcherChain;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.binding.ChainBinding.prototype.value;


/**
 * @private
 */
org.apache.flex.binding.ChainBinding.prototype.applyBinding = function() {
  var /** @type {boolean} */ chainSet = this.evaluateSourceChain();
  if (chainSet)
    this.applyValue();
};


/**
 * @private
 * @return {boolean}
 */
org.apache.flex.binding.ChainBinding.prototype.evaluateSourceChain = function() {
  var self = this;
  function valueChangeHandler(event) {
    if (event.propertyName != propName)
      return;
    this.value = event.newValue;
    this.applyValue();
  };
  var /** @type {number} */ n = this.source.length;
  var /** @type {Object} */ obj = this.document;
  for (var /** @type {number} */ i = 0; i < n - 1; i++) {
    var /** @type {string} */ propName = org.apache.flex.utils.Language.string(this.source[i]);
    var /** @type {Object} */ propObj = obj[propName];
    var /** @type {org.apache.flex.binding.ChainBinding.ChainWatcher} */ watcher = new org.apache.flex.binding.ChainBinding.ChainWatcher(propName, org.apache.flex.utils.Language.closure(this.applyBinding, this, 'applyBinding'));
    obj.addEventListener("valueChange", org.apache.flex.utils.Language.closure(watcher.handler, watcher, 'handler'));
    if (propObj == null)
      return false;
    obj = propObj;
  }
  propName = org.apache.flex.utils.Language.string(this.source[n - 1]);
  obj.addEventListener("valueChange", org.apache.flex.utils.Language.closure(valueChangeHandler, this, 'valueChangeHandler'));
  this.value = obj[propName];
  return true;
};


/**
 * @private
 */
org.apache.flex.binding.ChainBinding.prototype.applyValue = function() {
  var self = this;
  function handler(event) {
    if (event.propertyName != propName)
      return;
    if (event.oldValue != null)
      event.oldValue.removeEventListener("valueChange", org.apache.flex.utils.Language.closure(handler, this, 'handler'));
    this.applyValue();
  };
  var /** @type {string} */ destinationName;
  if (org.apache.flex.utils.Language.is(this.destination, String)) {
    destinationName = org.apache.flex.utils.Language.as(this.destination, String);
    this.document[destinationName] = this.value;
    return;
  }
  var /** @type {number} */ n = Number(this.destination.length);
  var /** @type {Object} */ obj = this.document;
  for (var /** @type {number} */ i = 0; i < n - 1; i++) {
    var /** @type {string} */ propName = org.apache.flex.utils.Language.string(this.destination[i]);
    var /** @type {Object} */ propObj = obj[propName];
    if (propObj == null) {
      obj.addEventListener("valueChange", org.apache.flex.utils.Language.closure(handler, this, 'handler'));
      return;
    }
    obj = propObj;
  }
  obj[this.destination[n - 1]] = this.value;
};


/**
 *  @copy org.apache.flex.core.IDocument#setDocument()
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} document
 * @param {string=} id
 */
org.apache.flex.binding.ChainBinding.prototype.setDocument = function(document, id) {
  id = typeof id !== 'undefined' ? id : null;
  this.document = document;
};


Object.defineProperties(org.apache.flex.binding.ChainBinding.prototype, /** @lends {org.apache.flex.binding.ChainBinding.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.binding.ChainBinding} */ function(value) {
  this.applyBinding();
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.binding.ChainBinding.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ChainBinding', qName: 'org.apache.flex.binding.ChainBinding'}], interfaces: [org.apache.flex.core.IBead, org.apache.flex.core.IDocument] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.binding.ChainBinding', org.apache.flex.binding.ChainBinding);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.binding.ChainBinding.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'source': { type: 'Array'},
        'destination': { type: 'Object'},
        'watcherChain': { type: 'Object'}
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.binding.ChainBinding'}
      };
    },
    methods: function () {
      return {
        'ChainBinding': { type: '', declaredBy: 'org.apache.flex.binding.ChainBinding'},
        'setDocument': { type: 'void', declaredBy: 'org.apache.flex.binding.ChainBinding'}
      };
    }
  };
};



/**
 * @constructor
 * @param {string} propertyName
 * @param {Function} callback
 */
org.apache.flex.binding.ChainBinding.ChainWatcher = function(propertyName, callback) {
  this.propertyName = propertyName;
  this.callback = callback;
};


/**
 * @private
 * @type {string}
 */
org.apache.flex.binding.ChainBinding.ChainWatcher.prototype.propertyName;


/**
 * @private
 * @type {Function}
 */
org.apache.flex.binding.ChainBinding.ChainWatcher.prototype.callback;


/**
 * @export
 * @param {org.apache.flex.events.ValueChangeEvent} event
 */
org.apache.flex.binding.ChainBinding.ChainWatcher.prototype.handler = function(event) {
  if (event.propertyName != this.propertyName)
    return;
  if (event.oldValue != null)
    event.oldValue.removeEventListener("valueChange", org.apache.flex.utils.Language.closure(this.handler, this, 'handler'));
  this.callback();
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.binding.ChainBinding.ChainWatcher.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ChainWatcher', qName: 'org.apache.flex.binding.ChainBinding.ChainWatcher'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.binding.ChainBinding.ChainWatcher', org.apache.flex.binding.ChainBinding.ChainWatcher);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.binding.ChainBinding.ChainWatcher.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'ChainWatcher': { type: '', declaredBy: 'org.apache.flex.binding.ChainBinding.ChainWatcher'},
        'handler': { type: 'void', declaredBy: 'org.apache.flex.binding.ChainBinding.ChainWatcher'}
      };
    }
  };
};