/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/svg/Ellipse.as
 * org.apache.flex.svg.Ellipse
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.svg.Ellipse');

goog.require('org.apache.flex.svg.GraphicShape');
goog.require('org.apache.flex.graphics.IEllipse');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7
 * @constructor
 * @extends {org.apache.flex.svg.GraphicShape}
 * @implements {org.apache.flex.graphics.IEllipse}
 * @param {number=} cx
 * @param {number=} cy
 * @param {number=} rx
 * @param {number=} ry
 */
org.apache.flex.svg.Ellipse = function(cx, cy, rx, ry) {
  org.apache.flex.svg.Ellipse.base(this, 'constructor');
  cx = typeof cx !== 'undefined' ? cx : 0;
  cy = typeof cy !== 'undefined' ? cy : 0;
  rx = typeof rx !== 'undefined' ? rx : 0;
  ry = typeof ry !== 'undefined' ? ry : 0;
  this.x = cx;
  this.y = cy;
  this.rx = rx;
  this.ry = ry;
};
goog.inherits(org.apache.flex.svg.Ellipse, org.apache.flex.svg.GraphicShape);


/**
 * @private
 * @type {number}
 */
org.apache.flex.svg.Ellipse.prototype._rx;


/**
 * @private
 * @type {number}
 */
org.apache.flex.svg.Ellipse.prototype._ry;


/**
 * @private
 * @type {org.apache.flex.core.WrappedHTMLElement}
 */
org.apache.flex.svg.Ellipse.prototype._ellipse;


/**
 *  Draw the ellipse.
 *  @asparam xp The x position of the top-left corner of the bounding box of the ellipse.
 *  @asparam yp The y position of the top-left corner of the bounding box of the ellipse.
 *  @asparam width The width of the ellipse.
 *  @asparam height The height of the ellipse.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 *  @flexjsignorecoercion SVGEllipseElement
 * @export
 * @param {number} xp
 * @param {number} yp
 */
org.apache.flex.svg.Ellipse.prototype.drawEllipse = function(xp, yp) {
  
  var /** @type {string} */ style = this.getStyleStr();
  if (this._ellipse == null) {
    this._ellipse = document.createElementNS('http://www.w3.org/2000/svg', 'ellipse');
    this._ellipse.flexjs_wrapper = this;
    this.element.appendChild(this._ellipse);
  }
  this._ellipse.setAttribute('style', style);
  if (this.stroke) {
    this._ellipse.setAttribute('cx', this.width / 2 + this.stroke.weight);
    this._ellipse.setAttribute('cy', this.height / 2 + this.stroke.weight);
  } else {
    this._ellipse.setAttribute('cx', this.width / 2);
    this._ellipse.setAttribute('cy', this.height / 2);
  }
  this._ellipse.setAttribute('rx', this.width / 2);
  this._ellipse.setAttribute('ry', this.height / 2);
  this.resize(this.x, this.y, this._ellipse.getBBox());
};


/**
 * @protected
 * @override
 */
org.apache.flex.svg.Ellipse.prototype.draw = function() {
  this.drawEllipse(0, 0);
};


Object.defineProperties(org.apache.flex.svg.Ellipse.prototype, /** @lends {org.apache.flex.svg.Ellipse.prototype} */ {
/** @export */
rx: {
get: /** @this {org.apache.flex.svg.Ellipse} */ function() {
  return this._rx;
},
set: /** @this {org.apache.flex.svg.Ellipse} */ function(value) {
  this._rx = value;
}},
/** @export */
ry: {
get: /** @this {org.apache.flex.svg.Ellipse} */ function() {
  return this._ry;
},
set: /** @this {org.apache.flex.svg.Ellipse} */ function(value) {
  this._ry = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.svg.Ellipse.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Ellipse', qName: 'org.apache.flex.svg.Ellipse'}], interfaces: [org.apache.flex.graphics.IEllipse] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.svg.Ellipse', org.apache.flex.svg.Ellipse);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.svg.Ellipse.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'rx': { type: 'Number', declaredBy: 'org.apache.flex.svg.Ellipse'},
        'ry': { type: 'Number', declaredBy: 'org.apache.flex.svg.Ellipse'}
      };
    },
    methods: function () {
      return {
        'Ellipse': { type: '', declaredBy: 'org.apache.flex.svg.Ellipse'},
        'drawEllipse': { type: 'void', declaredBy: 'org.apache.flex.svg.Ellipse'}
      };
    }
  };
};