/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/storage/providers/WebStorageProvider.as
 * org.apache.flex.storage.providers.WebStorageProvider
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.storage.providers.WebStorageProvider');

goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.storage.events.FileErrorEvent');
goog.require('org.apache.flex.storage.events.FileEvent');
goog.require('org.apache.flex.storage.file.DataInputStream');
goog.require('org.apache.flex.storage.file.DataOutputStream');
goog.require('org.apache.flex.storage.providers.IPermanentStorageProvider');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 * 
 * @asparam target The target dispatcher for events as files are read and written.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.storage.providers.IPermanentStorageProvider}
 * @param {org.apache.flex.events.IEventDispatcher=} target
 */
org.apache.flex.storage.providers.WebStorageProvider = function(target) {
  target = typeof target !== 'undefined' ? target : null;
  org.apache.flex.storage.providers.WebStorageProvider.base(this, 'constructor');
  this._target = target;
};
goog.inherits(org.apache.flex.storage.providers.WebStorageProvider, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {org.apache.flex.events.IEventDispatcher}
 */
org.apache.flex.storage.providers.WebStorageProvider.prototype._target;


/**
 * A convenience function to read an entire file as a single 
 * string of text. The file is storaged in the application's
 * data storage directory. Dispatches a FileRead event once
 * the data is available.
 * 
 *  @asparam fileName The name of the file.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} fileName
 */
org.apache.flex.storage.providers.WebStorageProvider.prototype.readTextFromDataFile = function(fileName) {
  var self = this;
  var /** @type {Function} */ __localFn0__ = function(fileEntry) {
    var /** @type {Function} */ __localFn0__ = function(file) {
      var /** @type {Function} */ __localFn0__ = function(e) {
        var /** @type {org.apache.flex.storage.events.FileEvent} */ newEvent = new org.apache.flex.storage.events.FileEvent("READ");
        newEvent.data = org.apache.flex.utils.Language.string(this.result);
        self._target.dispatchEvent(newEvent);
        var /** @type {org.apache.flex.storage.events.FileEvent} */ finEvent = new org.apache.flex.storage.events.FileEvent("COMPLETE");
        self._target.dispatchEvent(finEvent);
      }
      var /** @type {FileReader} */ reader = new FileReader();
      reader.onloadend = __localFn0__;
      reader.readAsText(file);
    }
    var /** @type {Function} */ __localFn1__ = function(e) {
      var /** @type {org.apache.flex.storage.events.FileErrorEvent} */ err1Event = new org.apache.flex.storage.events.FileErrorEvent("ERROR");
      err1Event.errorMessage = "Cannot open file for reading";
      err1Event.errorCode = 2;
      self._target.dispatchEvent(err1Event);
    }
    fileEntry.file(__localFn0__, __localFn1__);
  }
  var /** @type {Function} */ __localFn1__ = function(e) {
    var /** @type {org.apache.flex.storage.events.FileErrorEvent} */ err2Event = new org.apache.flex.storage.events.FileErrorEvent("ERROR");
    err2Event.errorMessage = "File does not exist";
    err2Event.errorCode = 1;
    self._target.dispatchEvent(err2Event);
  }
  var /** @type {string} */ fullPath = String(cordova["file"]["dataDirectory"]) + fileName;
  window.resolveLocalFileSystemURL(fullPath, __localFn0__, __localFn1__);
};


/**
 * Opens an input stream into a file in the data storage directory. A Ready
 * event is dispatched when the stream has been opened. Use the stream to
 * read data from the file.
 * 
 *  @asparam fileName The name of file.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} fileName
 */
org.apache.flex.storage.providers.WebStorageProvider.prototype.openInputDataStream = function(fileName) {
  var self = this;
  var /** @type {Function} */ __localFn0__ = function(fileEntry) {
    var /** @type {Function} */ __localFn0__ = function(file) {
      var /** @type {org.apache.flex.storage.file.DataInputStream} */ inputStream = new org.apache.flex.storage.file.DataInputStream(self._target, file, new FileReader());
      var /** @type {org.apache.flex.storage.events.FileEvent} */ newEvent = new org.apache.flex.storage.events.FileEvent("READY");
      newEvent.stream = inputStream;
      self._target.dispatchEvent(newEvent);
    }
    var /** @type {Function} */ __localFn1__ = function(e) {
      var /** @type {org.apache.flex.storage.events.FileErrorEvent} */ err1Event = new org.apache.flex.storage.events.FileErrorEvent("ERROR");
      err1Event.errorMessage = "Cannot open file for reading";
      err1Event.errorCode = 2;
      self._target.dispatchEvent(err1Event);
    }
    fileEntry.file(__localFn0__, __localFn1__);
  }
  var /** @type {Function} */ __localFn1__ = function(e) {
    var /** @type {org.apache.flex.storage.events.FileErrorEvent} */ err2Event = new org.apache.flex.storage.events.FileErrorEvent("ERROR");
    err2Event.errorMessage = "File does not exist";
    err2Event.errorCode = 1;
    self._target.dispatchEvent(err2Event);
  }
  var /** @type {string} */ fullPath = String(cordova["file"]["dataDirectory"]) + fileName;
  window.resolveLocalFileSystemURL(fullPath, __localFn0__, __localFn1__);
};


/**
 * A convenience function write a string into a file that resides in the
 * application's data storage directory. If the file already exists it is 
 * replaced with the string. Dispatches a FileWrite event once the file
 * has been written.
 * 
 *  @asparam fileName The name of file.
 *  @asparam text The string to be stored.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} fileName
 * @param {string} text
 */
org.apache.flex.storage.providers.WebStorageProvider.prototype.writeTextToDataFile = function(fileName, text) {
  var self = this;
  var /** @type {Function} */ __localFn0__ = function(directoryEntry) {
    var /** @type {Function} */ __localFn0__ = function(fileEntry) {
      var /** @type {Function} */ __localFn0__ = function(fileWriter) {
        var /** @type {Function} */ __localFn0__ = function(e) {
          var /** @type {org.apache.flex.storage.events.FileEvent} */ newEvent = new org.apache.flex.storage.events.FileEvent("WRITE");
          self._target.dispatchEvent(newEvent);
          var /** @type {org.apache.flex.storage.events.FileEvent} */ finEvent = new org.apache.flex.storage.events.FileEvent("COMPLETE");
          self._target.dispatchEvent(finEvent);
        }
        var /** @type {Function} */ __localFn1__ = function(e) {
          var /** @type {org.apache.flex.storage.events.FileErrorEvent} */ newEvent = new org.apache.flex.storage.events.FileErrorEvent("ERROR");
          newEvent.errorMessage = "Failed to write the file.";
          newEvent.errorCode = 3;
          self._target.dispatchEvent(newEvent);
        }
        fileWriter.onwriteend = __localFn0__;
        fileWriter.onerror = __localFn1__;
        var /** @type {Blob} */ blob = new Blob([text], {type:'text/plain'});
        fileWriter.write(blob);
      }
      var /** @type {Function} */ __localFn1__ = function(e) {
        var /** @type {org.apache.flex.storage.events.FileErrorEvent} */ errEvent = new org.apache.flex.storage.events.FileErrorEvent("ERROR");
        errEvent.errorMessage = "Cannot open file for writing.";
        errEvent.errorCode = 1;
        self._target.dispatchEvent(errEvent);
      }
      fileEntry.createWriter(__localFn0__, __localFn1__);
    }
    var /** @type {Function} */ __localFn1__ = function(e) {
      var /** @type {org.apache.flex.storage.events.FileErrorEvent} */ errEvent = new org.apache.flex.storage.events.FileErrorEvent("ERROR");
      errEvent.errorMessage = "Cannot create file.";
      errEvent.errorCode = 4;
      self._target.dispatchEvent(errEvent);
    }
    directoryEntry.getFile(fileName, {'create':true}, __localFn0__, __localFn1__);
  }
  var /** @type {Function} */ __localFn1__ = function(e) {
    var /** @type {org.apache.flex.storage.events.FileErrorEvent} */ errEvent = new org.apache.flex.storage.events.FileErrorEvent("ERROR");
    errEvent.errorMessage = "Cannot create file.";
    errEvent.errorCode = 4;
    self._target.dispatchEvent(errEvent);
  }
  var /** @type {string} */ fullPath = String(cordova["file"]["dataDirectory"]) + fileName;
  window.resolveLocalFileSystemURL(cordova.file.dataDirectory, __localFn0__, __localFn1__);
};


/**
 * Opens an output stream into a file in the data storage directory. A Ready
 * event is dispatched when the stream has been opened. Use the stream to
 * write data to the file.
 * 
 *  @asparam fileName The name of file.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} fileName
 */
org.apache.flex.storage.providers.WebStorageProvider.prototype.openOutputDataStream = function(fileName) {
  var self = this;
  var /** @type {Function} */ __localFn0__ = function(directoryEntry) {
    var /** @type {Function} */ __localFn0__ = function(fileEntry) {
      var /** @type {Function} */ __localFn0__ = function(fileWriter) {
        var /** @type {org.apache.flex.storage.file.DataOutputStream} */ outputStream = new org.apache.flex.storage.file.DataOutputStream(self._target, fileEntry, fileWriter);
        var /** @type {org.apache.flex.storage.events.FileEvent} */ newEvent = new org.apache.flex.storage.events.FileEvent("READY");
        newEvent.stream = outputStream;
        self._target.dispatchEvent(newEvent);
      }
      fileEntry.createWriter(__localFn0__);
    }
    directoryEntry.getFile(fileName, {'create':true}, __localFn0__);
  }
  var /** @type {string} */ fullPath = String(cordova["file"]["dataDirectory"]) + fileName;
  window.resolveLocalFileSystemURL(cordova.file.dataDirectory, __localFn0__);
};


Object.defineProperties(org.apache.flex.storage.providers.WebStorageProvider.prototype, /** @lends {org.apache.flex.storage.providers.WebStorageProvider.prototype} */ {
/** @export */
target: {
get: /** @this {org.apache.flex.storage.providers.WebStorageProvider} */ function() {
  return this._target;
},
set: /** @this {org.apache.flex.storage.providers.WebStorageProvider} */ function(value) {
  this._target = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.storage.providers.WebStorageProvider.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'WebStorageProvider', qName: 'org.apache.flex.storage.providers.WebStorageProvider'}], interfaces: [org.apache.flex.storage.providers.IPermanentStorageProvider] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.storage.providers.WebStorageProvider', org.apache.flex.storage.providers.WebStorageProvider);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.storage.providers.WebStorageProvider.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'target': { type: 'IEventDispatcher', declaredBy: 'org.apache.flex.storage.providers.WebStorageProvider'}
      };
    },
    methods: function () {
      return {
        'WebStorageProvider': { type: '', declaredBy: 'org.apache.flex.storage.providers.WebStorageProvider'},
        'readTextFromDataFile': { type: 'void', declaredBy: 'org.apache.flex.storage.providers.WebStorageProvider'},
        'openInputDataStream': { type: 'void', declaredBy: 'org.apache.flex.storage.providers.WebStorageProvider'},
        'writeTextToDataFile': { type: 'void', declaredBy: 'org.apache.flex.storage.providers.WebStorageProvider'},
        'openOutputDataStream': { type: 'void', declaredBy: 'org.apache.flex.storage.providers.WebStorageProvider'}
      };
    }
  };
};