/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/storage/providers/AirStorageProvider.as
 * org.apache.flex.storage.providers.AirStorageProvider
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.storage.providers.AirStorageProvider');

goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.storage.providers.IPermanentStorageProvider');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 * 
 * @asparam target The target dispatcher for events as files are read and written.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.storage.providers.IPermanentStorageProvider}
 * @param {org.apache.flex.events.IEventDispatcher=} target
 */
org.apache.flex.storage.providers.AirStorageProvider = function(target) {
  target = typeof target !== 'undefined' ? target : null;
  org.apache.flex.storage.providers.AirStorageProvider.base(this, 'constructor');
  this._target = target;
};
goog.inherits(org.apache.flex.storage.providers.AirStorageProvider, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {org.apache.flex.events.IEventDispatcher}
 */
org.apache.flex.storage.providers.AirStorageProvider.prototype._target;


/**
 * A convenience function to read an entire file as a single 
 * string of text. The file is storaged in the application's
 * data storage directory. Dispatches a FileRead event once
 * the data is available.
 * 
 *  @asparam fileName The name of the file.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} fileName
 */
org.apache.flex.storage.providers.AirStorageProvider.prototype.readTextFromDataFile = function(fileName) {
  
};


/**
 * Opens a file for input streaming. Events are dispatched when the file is ready
 * for reading, after each read, and when the file is closed. 
 * 
 *  @asparam fileName The name of the file.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} fileName
 */
org.apache.flex.storage.providers.AirStorageProvider.prototype.openInputDataStream = function(fileName) {
  
};


/**
 * A convenience function write a string into a file that resides in the
 * application's data storage directory. If the file already exists it is 
 * replaced with the string. Dispatches a FileWrite event once the file
 * has been written.
 * 
 *  @asparam fileName The name of file.
 *  @asparam text The string to be stored.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} fileName
 * @param {string} text
 */
org.apache.flex.storage.providers.AirStorageProvider.prototype.writeTextToDataFile = function(fileName, text) {
  
};


/**
 * Opens a file for output streaming. Events are dispatched when the file is ready
 * to receive output, after each write to the file, and when the file is closed.
 * 
 *  @asparam fileName The name of the file.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} fileName
 */
org.apache.flex.storage.providers.AirStorageProvider.prototype.openOutputDataStream = function(fileName) {
  
};


Object.defineProperties(org.apache.flex.storage.providers.AirStorageProvider.prototype, /** @lends {org.apache.flex.storage.providers.AirStorageProvider.prototype} */ {
/** @export */
target: {
get: /** @this {org.apache.flex.storage.providers.AirStorageProvider} */ function() {
  return this._target;
},
set: /** @this {org.apache.flex.storage.providers.AirStorageProvider} */ function(value) {
  this._target = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.storage.providers.AirStorageProvider.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'AirStorageProvider', qName: 'org.apache.flex.storage.providers.AirStorageProvider'}], interfaces: [org.apache.flex.storage.providers.IPermanentStorageProvider] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.storage.providers.AirStorageProvider', org.apache.flex.storage.providers.AirStorageProvider);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.storage.providers.AirStorageProvider.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'target': { type: 'IEventDispatcher', declaredBy: 'org.apache.flex.storage.providers.AirStorageProvider'}
      };
    },
    methods: function () {
      return {
        'AirStorageProvider': { type: '', declaredBy: 'org.apache.flex.storage.providers.AirStorageProvider'},
        'readTextFromDataFile': { type: 'void', declaredBy: 'org.apache.flex.storage.providers.AirStorageProvider'},
        'openInputDataStream': { type: 'void', declaredBy: 'org.apache.flex.storage.providers.AirStorageProvider'},
        'writeTextToDataFile': { type: 'void', declaredBy: 'org.apache.flex.storage.providers.AirStorageProvider'},
        'openOutputDataStream': { type: 'void', declaredBy: 'org.apache.flex.storage.providers.AirStorageProvider'}
      };
    }
  };
};