/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/storage/PermanentStorage.as
 * org.apache.flex.storage.PermanentStorage
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.storage.PermanentStorage');

goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.storage.IPermanentStorage');
goog.require('org.apache.flex.storage.providers.IPermanentStorageProvider');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.storage.IPermanentStorage}
 */
org.apache.flex.storage.PermanentStorage = function() {
  org.apache.flex.storage.PermanentStorage.base(this, 'constructor');
  this._storageProvider = org.apache.flex.utils.Language.as(org.apache.flex.core.ValuesManager.valuesImpl.newInstance(this, "iStorageProvider"), org.apache.flex.storage.providers.IPermanentStorageProvider);
  this._storageProvider.target = this;
};
goog.inherits(org.apache.flex.storage.PermanentStorage, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {org.apache.flex.storage.providers.IPermanentStorageProvider}
 */
org.apache.flex.storage.PermanentStorage.prototype._storageProvider;


/**
 * A convenience function to read an entire file as a single 
 * string of text. The file is storaged in the application's
 * data storage directory. Dispatches a FileRead event once
 * the data is available.
 * 
 *  @asparam fileName The name of the file.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} fileName
 */
org.apache.flex.storage.PermanentStorage.prototype.readTextFromDataFile = function(fileName) {
  this._storageProvider.readTextFromDataFile(fileName);
};


/**
 * A convenience function write a string into a file that resides in the
 * application's data storage directory. If the file already exists it is 
 * replaced with the string. Dispatches a FileWrite event once the file
 * has been written.
 * 
 *  @asparam fileName The name of file.
 *  @asparam text The string to be stored.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} fileName
 * @param {string} text
 */
org.apache.flex.storage.PermanentStorage.prototype.writeTextToDataFile = function(fileName, text) {
  this._storageProvider.writeTextToDataFile(fileName, text);
};


/**
 * Opens an output stream into a file in the data storage directory. A Ready
 * event is dispatched when the stream has been opened. Use the stream to
 * write data to the file.
 * 
 *  @asparam fileName The name of file.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} fileName
 */
org.apache.flex.storage.PermanentStorage.prototype.openOutputDataStream = function(fileName) {
  this._storageProvider.openOutputDataStream(fileName);
};


/**
 * Opens an input stream into a file in the data storage directory. A Ready
 * event is dispatched when the stream has been opened. Use the stream to
 * read data from the file.
 * 
 *  @asparam fileName The name of file.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} fileName
 */
org.apache.flex.storage.PermanentStorage.prototype.openInputDataStream = function(fileName) {
  this._storageProvider.openInputDataStream(fileName);
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.storage.PermanentStorage.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'PermanentStorage', qName: 'org.apache.flex.storage.PermanentStorage'}], interfaces: [org.apache.flex.storage.IPermanentStorage] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.storage.PermanentStorage', org.apache.flex.storage.PermanentStorage);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.storage.PermanentStorage.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'PermanentStorage': { type: '', declaredBy: 'org.apache.flex.storage.PermanentStorage'},
        'readTextFromDataFile': { type: 'void', declaredBy: 'org.apache.flex.storage.PermanentStorage'},
        'writeTextToDataFile': { type: 'void', declaredBy: 'org.apache.flex.storage.PermanentStorage'},
        'openOutputDataStream': { type: 'void', declaredBy: 'org.apache.flex.storage.PermanentStorage'},
        'openInputDataStream': { type: 'void', declaredBy: 'org.apache.flex.storage.PermanentStorage'}
      };
    }
  };
};