/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/states/AddItems.as
 * org.apache.flex.states.AddItems
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.states.AddItems');

goog.require('org.apache.flex.states.ItemAndDescriptor');
goog.require('org.apache.flex.core.IDocument');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @constructor
 * @implements {org.apache.flex.core.IDocument}
 */
org.apache.flex.states.AddItems = function() {
  ;
};


/**
 * @export
 * @type {Array}
 */
org.apache.flex.states.AddItems.prototype.items;


/**
 * @export
 * @type {number}
 */
org.apache.flex.states.AddItems.prototype.itemsDescriptorIndex;


/**
 * @export
 * @type {org.apache.flex.states.ItemAndDescriptor}
 */
org.apache.flex.states.AddItems.prototype.itemsDescriptor;


/**
 * @export
 * @type {string}
 */
org.apache.flex.states.AddItems.prototype.destination;


/**
 * @export
 * @type {string}
 */
org.apache.flex.states.AddItems.prototype.propertyName;


/**
 * @export
 * @type {string}
 */
org.apache.flex.states.AddItems.prototype.position;


/**
 * @export
 * @type {string}
 */
org.apache.flex.states.AddItems.prototype.relativeTo;


/**
 * @export
 * @type {Object}
 */
org.apache.flex.states.AddItems.prototype.document;


/**
 * @export
 * @param {Object} document
 * @param {string=} id
 */
org.apache.flex.states.AddItems.prototype.setDocument = function(document, id) {
  id = typeof id !== 'undefined' ? id : null;
  this.document = document;
  var /** @type {Object} */ data = document.mxmlsd[this.itemsDescriptorIndex];
  if (org.apache.flex.utils.Language.is(data, Array)) {
    this.itemsDescriptor = new org.apache.flex.states.ItemAndDescriptor();
    this.itemsDescriptor.descriptor = org.apache.flex.utils.Language.as(data, Array);
    document.mxmlsd[this.itemsDescriptorIndex] = this.itemsDescriptor;
  }
  else
    this.itemsDescriptor = org.apache.flex.utils.Language.as(data, org.apache.flex.states.ItemAndDescriptor);
};


/**
 * @asprivate 
 * Initialize this object from a descriptor.
 * @export
 * @param {Object} properties
 * @return {Object}
 */
org.apache.flex.states.AddItems.prototype.initializeFromObject = function(properties) {
  for (var /** @type {string} */ p in properties) {
    this[p] = properties[p];
  }
  return Object(this);
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.states.AddItems.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'AddItems', qName: 'org.apache.flex.states.AddItems'}], interfaces: [org.apache.flex.core.IDocument] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.states.AddItems', org.apache.flex.states.AddItems);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.states.AddItems.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'items': { type: 'Array'},
        'itemsDescriptorIndex': { type: 'int'},
        'itemsDescriptor': { type: 'ItemAndDescriptor'},
        'destination': { type: 'String'},
        'propertyName': { type: 'String'},
        'position': { type: 'String'},
        'relativeTo': { type: 'String'},
        'document': { type: 'Object'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'AddItems': { type: '', declaredBy: 'org.apache.flex.states.AddItems'},
        'setDocument': { type: 'void', declaredBy: 'org.apache.flex.states.AddItems'},
        'initializeFromObject': { type: 'Object', declaredBy: 'org.apache.flex.states.AddItems'}
      };
    },
    metadata: function () { return [ ]; }
  };
};