/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/supportClasses/ScrollingViewport.as
 * org.apache.flex.html.supportClasses.ScrollingViewport
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.supportClasses.ScrollingViewport');

goog.require('org.apache.flex.geom.Size');
goog.require('org.apache.flex.html.supportClasses.Viewport');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IViewport');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.supportClasses.Viewport}
 * @implements {org.apache.flex.core.IBead}
 * @implements {org.apache.flex.core.IViewport}
 */
org.apache.flex.html.supportClasses.ScrollingViewport = function() {
  org.apache.flex.html.supportClasses.ScrollingViewport.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.supportClasses.ScrollingViewport, org.apache.flex.html.supportClasses.Viewport);


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.supportClasses.ScrollingViewport.prototype.viewportWidth;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.supportClasses.ScrollingViewport.prototype.viewportHeight;


/**
 * @copy org.apache.flex.core.IViewport
 * @export
 * @override
 */
org.apache.flex.html.supportClasses.ScrollingViewport.prototype.layoutViewportBeforeContentLayout = function(width, height) {
  org.apache.flex.html.supportClasses.ScrollingViewport.base(this, 'layoutViewportBeforeContentLayout', width, height);
  this.viewportWidth = width;
  this.viewportHeight = height;
};


/**
 * @copy org.apache.flex.core.IViewport
 * @export
 * @override
 */
org.apache.flex.html.supportClasses.ScrollingViewport.prototype.layoutViewportAfterContentLayout = function() {
  
  return new org.apache.flex.geom.Size(this.contentView.width, this.contentView.height);
};


Object.defineProperties(org.apache.flex.html.supportClasses.ScrollingViewport.prototype, /** @lends {org.apache.flex.html.supportClasses.ScrollingViewport.prototype} */ {
/** @export */
verticalScrollPosition: {
get: /** @this {org.apache.flex.html.supportClasses.ScrollingViewport} */ function() {
  
  return this.contentView.positioner.scrollTop;
},
set: /** @this {org.apache.flex.html.supportClasses.ScrollingViewport} */ function(value) {
  
  this.contentView.positioner.scrollTop = value;
}},
/** @export */
horizontalScrollPosition: {
get: /** @this {org.apache.flex.html.supportClasses.ScrollingViewport} */ function() {
  
  return this.contentView.positioner.scrollLeft;
},
set: /** @this {org.apache.flex.html.supportClasses.ScrollingViewport} */ function(value) {
  
  this.contentView.positioner.scrollLeft = value;
}},
/** @export */
strand: {
set: /** @this {org.apache.flex.html.supportClasses.ScrollingViewport} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.html.supportClasses.ScrollingViewport, this, 'strand', value);
  this.contentView.element.style.overflow = 'auto';
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.supportClasses.ScrollingViewport.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ScrollingViewport', qName: 'org.apache.flex.html.supportClasses.ScrollingViewport'}], interfaces: [org.apache.flex.core.IBead, org.apache.flex.core.IViewport] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.supportClasses.ScrollingViewport', org.apache.flex.html.supportClasses.ScrollingViewport);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.supportClasses.ScrollingViewport.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'verticalScrollPosition': { type: 'Number', declaredBy: 'org.apache.flex.html.supportClasses.ScrollingViewport'},
        'horizontalScrollPosition': { type: 'Number', declaredBy: 'org.apache.flex.html.supportClasses.ScrollingViewport'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.supportClasses.ScrollingViewport'}
      };
    },
    methods: function () {
      return {
        'ScrollingViewport': { type: '', declaredBy: 'org.apache.flex.html.supportClasses.ScrollingViewport'},
        'layoutViewportBeforeContentLayout': { type: 'void', declaredBy: 'org.apache.flex.html.supportClasses.ScrollingViewport'},
        'layoutViewportAfterContentLayout': { type: 'Size', declaredBy: 'org.apache.flex.html.supportClasses.ScrollingViewport'}
      };
    }
  };
};