/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/layouts/BasicLayout.as
 * org.apache.flex.html.beads.layouts.BasicLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.layouts.BasicLayout');

goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.core.IBeadLayout');
goog.require('org.apache.flex.core.ILayoutChild');
goog.require('org.apache.flex.core.ILayoutHost');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBeadLayout}
 */
org.apache.flex.html.beads.layouts.BasicLayout = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.ILayoutChild}
 */
org.apache.flex.html.beads.layouts.BasicLayout.prototype.host;


/**
 * @copy org.apache.flex.core.IBeadLayout#layout
 * @flexjsignorecoercion org.apache.flex.core.ILayoutHost
 * @flexjsignorecoercion org.apache.flex.core.UIBase
 * @export
 * @return {boolean}
 */
org.apache.flex.html.beads.layouts.BasicLayout.prototype.layout = function() {
  
  var /** @type {number} */ i;
  var /** @type {number} */ n;
  var /** @type {number} */ h;
  var /** @type {number} */ w;
  var /** @type {Object} */ viewBead = this.host.getBeadByType(org.apache.flex.core.ILayoutHost);
  var /** @type {org.apache.flex.core.IParentIUIBase} */ contentView = viewBead.contentView;
  w = contentView.width;
  var /** @type {boolean} */ hasWidth = !this.host.isWidthSizedToContent();
  h = contentView.height;
  var /** @type {boolean} */ hasHeight = !this.host.isHeightSizedToContent();
  var /** @type {number} */ maxHeight = 0;
  var /** @type {number} */ maxWidth = 0;
  n = contentView.numElements;
  for (i = 0; i < n; i++) {
    var /** @type {Object} */ child = contentView.getElementAt(i);
    child.setDisplayStyleForLayout('block');
    var /** @type {number} */ left = Number(org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, 'left'));
    var /** @type {number} */ right = Number(org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, 'right'));
    var /** @type {number} */ top = Number(org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, 'top'));
    var /** @type {number} */ bottom = Number(org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, 'bottom'));
    var /** @type {string} */ margin = org.apache.flex.utils.Language.string(org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, 'margin'));
    var /** @type {string} */ marginLeft = org.apache.flex.utils.Language.string(org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, 'margin-left'));
    var /** @type {string} */ marginRight = org.apache.flex.utils.Language.string(org.apache.flex.core.ValuesManager.valuesImpl.getValue(child, 'margin-right'));
    var /** @type {boolean} */ horizontalCenter = (marginLeft == 'auto' && marginRight == 'auto') || (typeof(margin) === 'string' && margin == 'auto') || (margin && margin.hasOwnProperty('length') && ((margin.length < 4 && margin[1] == 'auto') || (margin.length == 4 && margin[1] == 'auto' && margin[3] == 'auto')));
    if (!isNaN(left)) {
      child.positioner.style.position = 'absolute';
      child.positioner.style.left = left.toString() + 'px';
    }
    if (!isNaN(top)) {
      child.positioner.style.position = 'absolute';
      child.positioner.style.top = top.toString() + 'px';
    }
    if (!isNaN(right)) {
      child.positioner.style.position = 'absolute';
      child.positioner.style.right = right.toString() + 'px';
    }
    if (!isNaN(bottom)) {
      child.positioner.style.position = 'absolute';
      child.positioner.style.bottom = bottom.toString() + 'px';
    }
    if (horizontalCenter) {
      child.positioner.style.position = 'absolute';
      child.positioner.style.left = ((w - child.width) / 2).toString() + 'px';
    }
    child.dispatchEvent('sizeChanged');
    maxWidth = Math.max(maxWidth, child.positioner.offsetLeft + child.positioner.offsetWidth);
    maxHeight = Math.max(maxHeight, child.positioner.offsetTop + child.positioner.offsetHeight);
  }
  if (!hasWidth && n > 0 && !isNaN(maxWidth)) {
    contentView.width = maxWidth;
  }
  if (!hasHeight && n > 0 && !isNaN(maxHeight)) {
    contentView.height = maxHeight;
  }
  return true;
};


Object.defineProperties(org.apache.flex.html.beads.layouts.BasicLayout.prototype, /** @lends {org.apache.flex.html.beads.layouts.BasicLayout.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.layouts.BasicLayout} */ function(value) {
  this.host = org.apache.flex.utils.Language.as(value, org.apache.flex.core.ILayoutChild);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.layouts.BasicLayout.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'BasicLayout', qName: 'org.apache.flex.html.beads.layouts.BasicLayout'}], interfaces: [org.apache.flex.core.IBeadLayout] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.layouts.BasicLayout', org.apache.flex.html.beads.layouts.BasicLayout);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.layouts.BasicLayout.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.layouts.BasicLayout'}
      };
    },
    methods: function () {
      return {
        'BasicLayout': { type: '', declaredBy: 'org.apache.flex.html.beads.layouts.BasicLayout'},
        'layout': { type: 'Boolean', declaredBy: 'org.apache.flex.html.beads.layouts.BasicLayout'}
      };
    }
  };
};