/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/controllers/SpinnerMouseController.as
 * org.apache.flex.html.beads.controllers.SpinnerMouseController
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.controllers.SpinnerMouseController');

goog.require('goog.events');
goog.require('goog.events.EventType');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.core.IBeadController');
goog.require('org.apache.flex.core.IRangeModel');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.html.beads.ISpinnerView');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBeadController}
 */
org.apache.flex.html.beads.controllers.SpinnerMouseController = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.IRangeModel}
 */
org.apache.flex.html.beads.controllers.SpinnerMouseController.prototype.rangeModel;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.beads.controllers.SpinnerMouseController.prototype._strand;


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.MouseEvent} event
 */
org.apache.flex.html.beads.controllers.SpinnerMouseController.prototype.decrementClickHandler = function(event) {
  this.rangeModel.value = Math.max(this.rangeModel.minimum, this.rangeModel.value - this.rangeModel.stepSize);
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event("valueChange"));
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.MouseEvent} event
 */
org.apache.flex.html.beads.controllers.SpinnerMouseController.prototype.incrementClickHandler = function(event) {
  this.rangeModel.value = Math.min(this.rangeModel.maximum, this.rangeModel.value + this.rangeModel.stepSize);
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event("valueChange"));
};


Object.defineProperties(org.apache.flex.html.beads.controllers.SpinnerMouseController.prototype, /** @lends {org.apache.flex.html.beads.controllers.SpinnerMouseController.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.controllers.SpinnerMouseController} */ function(value) {
  this._strand = value;
  this.rangeModel = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(value, org.apache.flex.core.UIBase, true).model, org.apache.flex.core.IRangeModel);
  
  var /** @type {org.apache.flex.html.beads.ISpinnerView} */ spinnerBead = org.apache.flex.utils.Language.as(value.getBeadByType(org.apache.flex.html.beads.ISpinnerView), org.apache.flex.html.beads.ISpinnerView);
  var /** @type {org.apache.flex.html.supportClasses.SpinnerButton} */ incrementButton = spinnerBead.increment;
  var /** @type {org.apache.flex.html.supportClasses.SpinnerButton} */ decrementButton = spinnerBead.decrement;
  goog.events.listen(incrementButton.element, goog.events.EventType.CLICK, org.apache.flex.utils.Language.closure(this.incrementClickHandler, this, 'incrementClickHandler'));
  goog.events.listen(decrementButton.element, goog.events.EventType.CLICK, org.apache.flex.utils.Language.closure(this.decrementClickHandler, this, 'decrementClickHandler'));
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.controllers.SpinnerMouseController.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'SpinnerMouseController', qName: 'org.apache.flex.html.beads.controllers.SpinnerMouseController'}], interfaces: [org.apache.flex.core.IBeadController] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.controllers.SpinnerMouseController', org.apache.flex.html.beads.controllers.SpinnerMouseController);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.controllers.SpinnerMouseController.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.controllers.SpinnerMouseController'}
      };
    },
    methods: function () {
      return {
        'SpinnerMouseController': { type: '', declaredBy: 'org.apache.flex.html.beads.controllers.SpinnerMouseController'}
      };
    }
  };
};