/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/controllers/ItemRendererMouseController.as
 * org.apache.flex.html.beads.controllers.ItemRendererMouseController
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.controllers.ItemRendererMouseController');

goog.require('goog.events');
goog.require('goog.events.EventType');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.events.ItemClickedEvent');
goog.require('org.apache.flex.core.IBeadController');
goog.require('org.apache.flex.core.ISelectableItemRenderer');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBeadController}
 */
org.apache.flex.html.beads.controllers.ItemRendererMouseController = function() {
};


/**
 * @private
 * @type {org.apache.flex.core.ISelectableItemRenderer}
 */
org.apache.flex.html.beads.controllers.ItemRendererMouseController.prototype.renderer;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.beads.controllers.ItemRendererMouseController.prototype._strand;


/**
 * @protected
 * @param {org.apache.flex.events.BrowserEvent} event
 */
org.apache.flex.html.beads.controllers.ItemRendererMouseController.prototype.handleMouseOver = function(event) {
  var /** @type {org.apache.flex.core.ISelectableItemRenderer} */ target = org.apache.flex.utils.Language.as(event.currentTarget, org.apache.flex.core.ISelectableItemRenderer);
  if (target) {
    target.dispatchEvent(new goog.events.Event("itemRollOver", true));
  }
};


/**
 * @protected
 * @param {org.apache.flex.events.BrowserEvent} event
 */
org.apache.flex.html.beads.controllers.ItemRendererMouseController.prototype.handleMouseOut = function(event) {
  var /** @type {org.apache.flex.core.ISelectableItemRenderer} */ target = org.apache.flex.utils.Language.as(event.currentTarget, org.apache.flex.core.ISelectableItemRenderer);
  if (target) {
    target.dispatchEvent(new goog.events.Event("itemRollOut", true));
  }
};


/**
 * @asprivate
 * @protected
 * @param {org.apache.flex.events.BrowserEvent} event
 */
org.apache.flex.html.beads.controllers.ItemRendererMouseController.prototype.handleMouseDown = function(event) {
  var /** @type {org.apache.flex.core.ISelectableItemRenderer} */ target = org.apache.flex.utils.Language.as(event.currentTarget, org.apache.flex.core.ISelectableItemRenderer);
  if (target) {
    target.down = true;
    target.hovered = false;
  }
};


/**
 * @asprivate
 * @protected
 * @param {org.apache.flex.events.BrowserEvent} event
 */
org.apache.flex.html.beads.controllers.ItemRendererMouseController.prototype.handleMouseUp = function(event) {
  var /** @type {org.apache.flex.core.ISelectableItemRenderer} */ target = org.apache.flex.utils.Language.as(event.currentTarget, org.apache.flex.core.ISelectableItemRenderer);
  if (target) {
    var /** @type {org.apache.flex.events.ItemClickedEvent} */ newEvent = new org.apache.flex.events.ItemClickedEvent("itemClicked");
    newEvent.data = target.data;
    newEvent.multipleSelection = event.shiftKey;
    newEvent.index = target.index;
    target.dispatchEvent(newEvent);
  }
};


Object.defineProperties(org.apache.flex.html.beads.controllers.ItemRendererMouseController.prototype, /** @lends {org.apache.flex.html.beads.controllers.ItemRendererMouseController.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.controllers.ItemRendererMouseController} */ function(value) {
  this._strand = value;
  this.renderer = org.apache.flex.utils.Language.as(value, org.apache.flex.core.ISelectableItemRenderer);
  
  var /** @type {org.apache.flex.core.WrappedHTMLElement} */ element = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase).element;
  goog.events.listen(element, goog.events.EventType.MOUSEOVER, org.apache.flex.utils.Language.closure(this.handleMouseOver, this, 'handleMouseOver'));
  goog.events.listen(element, goog.events.EventType.MOUSEOUT, org.apache.flex.utils.Language.closure(this.handleMouseOut, this, 'handleMouseOut'));
  goog.events.listen(element, goog.events.EventType.MOUSEDOWN, org.apache.flex.utils.Language.closure(this.handleMouseDown, this, 'handleMouseDown'));
  goog.events.listen(element, goog.events.EventType.MOUSEUP, org.apache.flex.utils.Language.closure(this.handleMouseUp, this, 'handleMouseUp'));
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.controllers.ItemRendererMouseController.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ItemRendererMouseController', qName: 'org.apache.flex.html.beads.controllers.ItemRendererMouseController'}], interfaces: [org.apache.flex.core.IBeadController] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.controllers.ItemRendererMouseController', org.apache.flex.html.beads.controllers.ItemRendererMouseController);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.controllers.ItemRendererMouseController.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.controllers.ItemRendererMouseController'}
      };
    },
    methods: function () {
      return {
        'ItemRendererMouseController': { type: '', declaredBy: 'org.apache.flex.html.beads.controllers.ItemRendererMouseController'}
      };
    }
  };
};