/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/RangeStepperView.as
 * org.apache.flex.html.beads.RangeStepperView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.RangeStepperView');

goog.require('org.apache.flex.core.BeadViewBase');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.graphics.SolidColorStroke');
goog.require('org.apache.flex.html.ImageButton');
goog.require('org.apache.flex.html.Label');
goog.require('org.apache.flex.html.beads.models.RangeModelExtended');
goog.require('org.apache.flex.svg.Rect');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.BeadViewBase}
 * @implements {org.apache.flex.core.IBeadView}
 */
org.apache.flex.html.beads.RangeStepperView = function() {
  org.apache.flex.html.beads.RangeStepperView.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.beads.RangeStepperView, org.apache.flex.core.BeadViewBase);


/**
 * @private
 * @type {org.apache.flex.html.Label}
 */
org.apache.flex.html.beads.RangeStepperView.prototype._label;


/**
 * @private
 * @type {org.apache.flex.html.ImageButton}
 */
org.apache.flex.html.beads.RangeStepperView.prototype._incrementButton;


/**
 * @private
 * @type {org.apache.flex.html.ImageButton}
 */
org.apache.flex.html.beads.RangeStepperView.prototype._decrementButton;


/**
 * @private
 * @type {org.apache.flex.svg.Rect}
 */
org.apache.flex.html.beads.RangeStepperView.prototype._labelBox;


/**
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.RangeStepperView.prototype.sizeChangeHandler = function(event) {
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase);
  this._incrementButton.x = 0;
  this._incrementButton.y = 0;
  this._incrementButton.setWidthAndHeight(host.width, 20);
  this._label.x = 0;
  this._label.y = this._incrementButton.height + 2;
  this._label.setWidthAndHeight(host.width, host.height - 40, true);
  this._labelBox.x = this._label.x;
  this._labelBox.y = this._label.y - 2;
  this._labelBox.drawRect(0, 0, this._label.width - 1, this._label.height);
  this._decrementButton.x = 0;
  this._decrementButton.y = host.height - 20;
  this._decrementButton.setWidthAndHeight(host.width, 20);
};


/**
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.RangeStepperView.prototype.handleValueChange = function(event) {
  var /** @type {org.apache.flex.html.beads.models.RangeModelExtended} */ model = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase).model, org.apache.flex.html.beads.models.RangeModelExtended);
  this._label.text = model.getLabelForIndex(model.value);
};


Object.defineProperties(org.apache.flex.html.beads.RangeStepperView.prototype, /** @lends {org.apache.flex.html.beads.RangeStepperView.prototype} */ {
/** @export */
incrementButton: {
get: /** @this {org.apache.flex.html.beads.RangeStepperView} */ function() {
  return this._incrementButton;
}},
/** @export */
decrementButton: {
get: /** @this {org.apache.flex.html.beads.RangeStepperView} */ function() {
  return this._decrementButton;
}},
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.RangeStepperView} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.html.beads.RangeStepperView, this, 'strand', value);
  this._strand = value;
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase);
  this._labelBox = new org.apache.flex.svg.Rect();
  this._labelBox.stroke = new org.apache.flex.graphics.SolidColorStroke();
  org.apache.flex.utils.Language.as(this._labelBox.stroke, org.apache.flex.graphics.SolidColorStroke).color = 0x000000;
  org.apache.flex.utils.Language.as(this._labelBox.stroke, org.apache.flex.graphics.SolidColorStroke).weight = 1.0;
  this._incrementButton = new org.apache.flex.html.ImageButton();
  this._incrementButton.source = "assets/up-arrow.png";
  this._decrementButton = new org.apache.flex.html.ImageButton();
  this._decrementButton.source = "assets/down-arrow.png";
  org.apache.flex.utils.Language.as(value, org.apache.flex.events.IEventDispatcher, true).addEventListener("widthChanged", org.apache.flex.utils.Language.closure(this.sizeChangeHandler, this, 'sizeChangeHandler'));
  org.apache.flex.utils.Language.as(value, org.apache.flex.events.IEventDispatcher, true).addEventListener("heightChanged", org.apache.flex.utils.Language.closure(this.sizeChangeHandler, this, 'sizeChangeHandler'));
  this._label = new org.apache.flex.html.Label();
  host.addElement(this._labelBox);
  host.addElement(this._incrementButton);
  host.addElement(this._decrementButton);
  host.addElement(this._label);
  var /** @type {org.apache.flex.html.beads.models.RangeModelExtended} */ model = org.apache.flex.utils.Language.as(host.model, org.apache.flex.html.beads.models.RangeModelExtended);
  model.addEventListener("valueChange", org.apache.flex.utils.Language.closure(this.handleValueChange, this, 'handleValueChange'));
  this.sizeChangeHandler(null);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.RangeStepperView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'RangeStepperView', qName: 'org.apache.flex.html.beads.RangeStepperView'}], interfaces: [org.apache.flex.core.IBeadView] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.RangeStepperView', org.apache.flex.html.beads.RangeStepperView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.RangeStepperView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'incrementButton': { type: 'ImageButton', declaredBy: 'org.apache.flex.html.beads.RangeStepperView'},
        'decrementButton': { type: 'ImageButton', declaredBy: 'org.apache.flex.html.beads.RangeStepperView'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.RangeStepperView'}
      };
    },
    methods: function () {
      return {
        'RangeStepperView': { type: '', declaredBy: 'org.apache.flex.html.beads.RangeStepperView'}
      };
    }
  };
};