/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/DataItemRendererFactoryForArrayList.as
 * org.apache.flex.html.beads.DataItemRendererFactoryForArrayList
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.DataItemRendererFactoryForArrayList');

goog.require('org.apache.flex.core.SimpleCSSStyles');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.html.List');
goog.require('org.apache.flex.collections.IArrayList');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IDataProviderItemRendererMapper');
goog.require('org.apache.flex.core.IItemRendererClassFactory');
goog.require('org.apache.flex.core.IListPresentationModel');
goog.require('org.apache.flex.core.ISelectableItemRenderer');
goog.require('org.apache.flex.core.ISelectionModel');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.html.beads.IListView');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBead}
 * @implements {org.apache.flex.core.IDataProviderItemRendererMapper}
 */
org.apache.flex.html.beads.DataItemRendererFactoryForArrayList = function() {
};


/**
 * @protected
 * @type {org.apache.flex.core.ISelectionModel}
 */
org.apache.flex.html.beads.DataItemRendererFactoryForArrayList.prototype.selectionModel;


/**
 * @protected
 * @type {string}
 */
org.apache.flex.html.beads.DataItemRendererFactoryForArrayList.prototype.labelField;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.beads.DataItemRendererFactoryForArrayList.prototype._strand;


/**
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.DataItemRendererFactoryForArrayList.prototype.finishSetup = function(event) {
  this.selectionModel = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.ISelectionModel), org.apache.flex.core.ISelectionModel);
  var /** @type {org.apache.flex.html.beads.IListView} */ listView = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.html.beads.IListView), org.apache.flex.html.beads.IListView);
  this.dataGroup = listView.dataGroup;
  this.selectionModel.addEventListener("dataProviderChanged", org.apache.flex.utils.Language.closure(this.dataProviderChangeHandler, this, 'dataProviderChangeHandler'));
  this.labelField = org.apache.flex.utils.Language.as(listView.host, org.apache.flex.html.List).labelField;
  if (!this.itemRendererFactory) {
    this._itemRendererFactory = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IItemRendererClassFactory), org.apache.flex.core.IItemRendererClassFactory);
    if (this._itemRendererFactory == null) {
      this._itemRendererFactory = org.apache.flex.utils.Language.as(new (org.apache.flex.core.ValuesManager.valuesImpl.getValue(this._strand, "iItemRendererClassFactory"))(), org.apache.flex.core.IItemRendererClassFactory);
      this._strand.addBead(this._itemRendererFactory);
    }
  }
  this.dataProviderChangeHandler(null);
};


/**
 * @private
 * @type {org.apache.flex.core.IItemRendererClassFactory}
 */
org.apache.flex.html.beads.DataItemRendererFactoryForArrayList.prototype._itemRendererFactory;


/**
 * @protected
 * @type {org.apache.flex.core.IItemRendererParent}
 */
org.apache.flex.html.beads.DataItemRendererFactoryForArrayList.prototype.dataGroup;


/**
 * @asprivate
 * @protected
 * @param {org.apache.flex.core.ISelectableItemRenderer} ir
 * @param {Object} data
 * @param {number} index
 */
org.apache.flex.html.beads.DataItemRendererFactoryForArrayList.prototype.setData = function(ir, data, index) {
  ir.index = index;
  ir.labelField = this.labelField;
  ir.data = data;
};


/**
 * @asprivate
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.DataItemRendererFactoryForArrayList.prototype.dataProviderChangeHandler = function(event) {
  var /** @type {org.apache.flex.collections.IArrayList} */ dp = org.apache.flex.utils.Language.as(this.selectionModel.dataProvider, org.apache.flex.collections.IArrayList);
  if (!dp)
    return;
  this.dataGroup.removeAllElements();
  var /** @type {org.apache.flex.html.beads.IListView} */ listView = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.html.beads.IListView), org.apache.flex.html.beads.IListView);
  var /** @type {org.apache.flex.core.IListPresentationModel} */ presentationModel = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IListPresentationModel), org.apache.flex.core.IListPresentationModel);
  var /** @type {number} */ n = dp.length;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {org.apache.flex.core.ISelectableItemRenderer} */ ir = org.apache.flex.utils.Language.as(this.itemRendererFactory.createItemRenderer(this.dataGroup), org.apache.flex.core.ISelectableItemRenderer);
    if (presentationModel) {
      org.apache.flex.utils.Language.as(ir, org.apache.flex.core.UIBase, true).height = presentationModel.rowHeight;
      var /** @type {org.apache.flex.core.SimpleCSSStyles} */ style = new org.apache.flex.core.SimpleCSSStyles();
      style.right = 0;
      style.left = 0;
      org.apache.flex.utils.Language.as(ir, org.apache.flex.core.UIBase, true).style = style;
    }
    this.dataGroup.addElement(ir);
    this.setData(ir, dp.getItemAt(i), i);
  }
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event("itemsCreated"));
};


Object.defineProperties(org.apache.flex.html.beads.DataItemRendererFactoryForArrayList.prototype, /** @lends {org.apache.flex.html.beads.DataItemRendererFactoryForArrayList.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.DataItemRendererFactoryForArrayList} */ function(value) {
  this._strand = value;
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).addEventListener("beadsAdded", org.apache.flex.utils.Language.closure(this.finishSetup, this, 'finishSetup'));
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).addEventListener("initComplete", org.apache.flex.utils.Language.closure(this.finishSetup, this, 'finishSetup'));
}},
/** @export */
itemRendererFactory: {
get: /** @this {org.apache.flex.html.beads.DataItemRendererFactoryForArrayList} */ function() {
  return this._itemRendererFactory;
},
set: /** @this {org.apache.flex.html.beads.DataItemRendererFactoryForArrayList} */ function(value) {
  this._itemRendererFactory = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.DataItemRendererFactoryForArrayList.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DataItemRendererFactoryForArrayList', qName: 'org.apache.flex.html.beads.DataItemRendererFactoryForArrayList'}], interfaces: [org.apache.flex.core.IBead, org.apache.flex.core.IDataProviderItemRendererMapper] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.DataItemRendererFactoryForArrayList', org.apache.flex.html.beads.DataItemRendererFactoryForArrayList);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.DataItemRendererFactoryForArrayList.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.DataItemRendererFactoryForArrayList'},
        'itemRendererFactory': { type: 'IItemRendererClassFactory', declaredBy: 'org.apache.flex.html.beads.DataItemRendererFactoryForArrayList'}
      };
    },
    methods: function () {
      return {
        'DataItemRendererFactoryForArrayList': { type: '', declaredBy: 'org.apache.flex.html.beads.DataItemRendererFactoryForArrayList'}
      };
    }
  };
};