/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/ContainerView.as
 * org.apache.flex.html.beads.ContainerView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.ContainerView');

goog.require('org.apache.flex.core.BeadViewBase');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.geom.Rectangle');
goog.require('org.apache.flex.utils.CSSContainerUtils');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IBeadLayout');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.core.IContainerView');
goog.require('org.apache.flex.core.IContentViewHost');
goog.require('org.apache.flex.core.ILayoutChild');
goog.require('org.apache.flex.core.ILayoutHost');
goog.require('org.apache.flex.core.IParentIUIBase');
goog.require('org.apache.flex.core.IUIBase');
goog.require('org.apache.flex.core.IViewport');
goog.require('org.apache.flex.core.IViewportModel');
goog.require('org.apache.flex.html.beads.IBackgroundBead');
goog.require('org.apache.flex.html.beads.IBorderBead');
goog.require('org.apache.flex.utils.Language');



/**
 *  The ContainerView class is the default view for
 *  the org.apache.flex.core.ContainerBase classes.
 *  It lets you use some CSS styles to manage the border, background
 *  and padding around the content area.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.BeadViewBase}
 * @implements {org.apache.flex.core.IBeadView}
 * @implements {org.apache.flex.core.IContainerView}
 * @implements {org.apache.flex.core.ILayoutHost}
 */
org.apache.flex.html.beads.ContainerView = function() {
  org.apache.flex.html.beads.ContainerView.base(this, 'constructor');
  this.layoutRunning = false;
};
goog.inherits(org.apache.flex.html.beads.ContainerView, org.apache.flex.core.BeadViewBase);


/**
 * @private
 * @type {org.apache.flex.core.IViewportModel}
 */
org.apache.flex.html.beads.ContainerView.prototype._viewportModel;


/**
 * @private
 * @type {org.apache.flex.core.IViewport}
 */
org.apache.flex.html.beads.ContainerView.prototype._viewport;


/**
 * @private
 * @type {boolean}
 */
org.apache.flex.html.beads.ContainerView.prototype.layoutRunning;


/**
 * @asprivate
 * @export
 * @param {Object} c
 * @param {boolean=} dispatchEvent
 */
org.apache.flex.html.beads.ContainerView.prototype.addElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  this.contentView.addElement(c, dispatchEvent);
};


/**
 * @asprivate
 * @export
 * @param {Object} c
 * @param {number} index
 * @param {boolean=} dispatchEvent
 */
org.apache.flex.html.beads.ContainerView.prototype.addElementAt = function(c, index, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  this.contentView.addElementAt(c, index, dispatchEvent);
};


/**
 * @asprivate
 * @export
 * @param {Object} c
 * @return {number}
 */
org.apache.flex.html.beads.ContainerView.prototype.getElementIndex = function(c) {
  return this.contentView.getElementIndex(c);
};


/**
 * @asprivate
 * @export
 * @param {Object} c
 * @param {boolean=} dispatchEvent
 */
org.apache.flex.html.beads.ContainerView.prototype.removeElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  this.contentView.removeElement(c, dispatchEvent);
};


/**
 * @asprivate
 * @export
 * @param {number} index
 * @return {Object}
 */
org.apache.flex.html.beads.ContainerView.prototype.getElementAt = function(index) {
  return this.contentView.getElementAt(index);
};


/**
 * Handles the initComplete event by completing the setup and kicking off the
 * presentation of the Container.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.ContainerView.prototype.initCompleteHandler = function(event) {
  var /** @type {org.apache.flex.core.ILayoutChild} */ ilc = org.apache.flex.utils.Language.as(this.host, org.apache.flex.core.ILayoutChild);
  if ((ilc.isHeightSizedToContent() || !isNaN(ilc.explicitHeight)) && (ilc.isWidthSizedToContent() || !isNaN(ilc.explicitWidth))) {
    this.completeSetup();
    var /** @type {number} */ num = this.contentView.numElements;
    if (num > 0)
      this.performLayout(event);
  } else {
    this.host.addEventListener("sizeChanged", org.apache.flex.utils.Language.closure(this.deferredSizeHandler, this, 'deferredSizeHandler'));
    this.host.addEventListener("widthChanged", org.apache.flex.utils.Language.closure(this.deferredSizeHandler, this, 'deferredSizeHandler'));
    this.host.addEventListener("heightChanged", org.apache.flex.utils.Language.closure(this.deferredSizeHandler, this, 'deferredSizeHandler'));
  }
};


/**
 * Handles the case where the size of the host is not immediately known, usually do
 * to one of its dimensions being indicated as a percent size.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.ContainerView.prototype.deferredSizeHandler = function(event) {
  this.host.removeEventListener("sizeChanged", org.apache.flex.utils.Language.closure(this.deferredSizeHandler, this, 'deferredSizeHandler'));
  this.host.removeEventListener("widthChanged", org.apache.flex.utils.Language.closure(this.deferredSizeHandler, this, 'deferredSizeHandler'));
  this.host.removeEventListener("heightChanged", org.apache.flex.utils.Language.closure(this.deferredSizeHandler, this, 'deferredSizeHandler'));
  this.completeSetup();
  var /** @type {number} */ num = this.contentView.numElements;
  if (num > 0) {
    this.performLayout(event);
  }
};


/**
 * Called when the host is ready to complete its setup (usually after its size has been
 * determined).
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 */
org.apache.flex.html.beads.ContainerView.prototype.completeSetup = function() {
  this.host.addEventListener("layoutComplete", org.apache.flex.utils.Language.closure(this.childrenChangedHandler, this, 'childrenChangedHandler'));
  this.host.addEventListener("childrenAdded", org.apache.flex.utils.Language.closure(this.performLayout, this, 'performLayout'));
  this.host.addEventListener("layoutNeeded", org.apache.flex.utils.Language.closure(this.performLayout, this, 'performLayout'));
  this.host.addEventListener("widthChanged", org.apache.flex.utils.Language.closure(this.resizeHandler, this, 'resizeHandler'));
  this.host.addEventListener("heightChanged", org.apache.flex.utils.Language.closure(this.resizeHandler, this, 'resizeHandler'));
  this.host.addEventListener("sizeChanged", org.apache.flex.utils.Language.closure(this.resizeHandler, this, 'resizeHandler'));
  this.host.addEventListener("viewCreated", org.apache.flex.utils.Language.closure(this.viewCreatedHandler, this, 'viewCreatedHandler'));
};


/**
 * Handles the viewCreated event by performing the first layout if
 * there are children already present (ie, from MXML).
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.ContainerView.prototype.viewCreatedHandler = function(event) {
  if (org.apache.flex.utils.Language.as(this.host, org.apache.flex.core.UIBase).numElements > 0) {
    this.performLayout(null);
  }
};


/**
 * Calculate the space taken up by non-content children like a TItleBar in a Panel.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 * @return {org.apache.flex.geom.Rectangle}
 */
org.apache.flex.html.beads.ContainerView.prototype.getChromeMetrics = function() {
  return new org.apache.flex.geom.Rectangle(0, 0, 0, 0);
};


/**
 * Creates the Viewport (or ScrollableViewport) through which the content
 * area is presented.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 */
org.apache.flex.html.beads.ContainerView.prototype.createViewport = function() {
  var /** @type {Object} */ c;
  if (this.viewportModel == null) {
    this._viewportModel = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IViewportModel), org.apache.flex.core.IViewportModel);
    if (this.viewportModel == null) {
      c = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this.host, "iViewportModel");
      if (c) {
        this._viewportModel = org.apache.flex.utils.Language.as(new c(), org.apache.flex.core.IViewportModel);
        this._strand.addBead(this._viewportModel);
      }
    }
  }
  if (this.viewport == null) {
    this._viewport = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IViewport), org.apache.flex.core.IViewport);
    if (this.viewport == null) {
      c = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this.host, "iViewport");
      if (c) {
        this._viewport = org.apache.flex.utils.Language.as(new c(), org.apache.flex.core.IViewport);
        this._strand.addBead(this.viewport);
      }
    }
  }
};


/**
 *  Positions the viewport, then sets any known sizes of the Viewport prior
 *  to laying out its content.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 */
org.apache.flex.html.beads.ContainerView.prototype.layoutViewBeforeContentLayout = function() {
  var /** @type {org.apache.flex.core.ILayoutChild} */ host = org.apache.flex.utils.Language.as(this.host, org.apache.flex.core.ILayoutChild);
  var /** @type {org.apache.flex.core.IViewportModel} */ vm = this.viewportModel;
  vm.borderMetrics = org.apache.flex.utils.CSSContainerUtils.getBorderMetrics(host);
  vm.chromeMetrics = this.getChromeMetrics();
  this.viewport.setPosition(vm.borderMetrics.left + vm.chromeMetrics.left, vm.borderMetrics.top + vm.chromeMetrics.top);
  this.viewport.layoutViewportBeforeContentLayout(!host.isWidthSizedToContent() ? host.width - vm.borderMetrics.left - vm.borderMetrics.right - vm.chromeMetrics.left - vm.chromeMetrics.right : NaN, !host.isHeightSizedToContent() ? host.height - vm.borderMetrics.top - vm.borderMetrics.bottom - vm.chromeMetrics.top - vm.chromeMetrics.bottom : NaN);
};


/**
 * Executes the layout associated with this container. Once the layout has been
 * run, it may affect the size of the host or may cause the host to present scroll
 * bars view its viewport.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.ContainerView.prototype.performLayout = function(event) {
  this.layoutRunning = true;
  this.layoutViewBeforeContentLayout();
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase);
  var /** @type {org.apache.flex.core.IBeadLayout} */ layout = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IBeadLayout), org.apache.flex.core.IBeadLayout);
  if (layout == null) {
    var /** @type {Object} */ c = org.apache.flex.core.ValuesManager.valuesImpl.getValue(host, "iBeadLayout");
    if (c) {
      layout = org.apache.flex.utils.Language.as(new c(), org.apache.flex.core.IBeadLayout);
      this._strand.addBead(layout);
    }
  }
  if (layout) {
    layout.layout();
  }
  this.layoutViewAfterContentLayout();
  this.layoutRunning = false;
};


/**
 * @private
 * @type {boolean}
 */
org.apache.flex.html.beads.ContainerView.prototype.adjusting = false;


/**
 * Adjusts the size of the host, or adds scrollbars to the viewport, after
 * the layout has been run.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 */
org.apache.flex.html.beads.ContainerView.prototype.layoutViewAfterContentLayout = function() {
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase);
  var /** @type {org.apache.flex.core.IViewportModel} */ vm = this.viewportModel;
  this.adjusting = true;
  var /** @type {org.apache.flex.geom.Size} */ viewportSize = this.viewport.layoutViewportAfterContentLayout();
  if (host.isWidthSizedToContent() && host.isHeightSizedToContent()) {
    host.setWidthAndHeight(viewportSize.width + vm.borderMetrics.left + vm.borderMetrics.right + vm.chromeMetrics.left + vm.chromeMetrics.right, viewportSize.height + vm.borderMetrics.top + vm.borderMetrics.bottom + vm.chromeMetrics.top + vm.chromeMetrics.bottom, false);
  } else if (!host.isWidthSizedToContent() && host.isHeightSizedToContent()) {
    host.setHeight(viewportSize.height + vm.borderMetrics.top + vm.borderMetrics.bottom + vm.chromeMetrics.top + vm.chromeMetrics.bottom, false);
  } else if (host.isWidthSizedToContent() && !host.isHeightSizedToContent()) {
    host.setWidth(viewportSize.width + vm.borderMetrics.left + vm.borderMetrics.right + vm.chromeMetrics.left + vm.chromeMetrics.right, false);
  }
  this.adjusting = false;
};


/**
 * Handles dynamic changes to the host's size by running the layout once
 * the viewport has been adjusted.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.ContainerView.prototype.resizeHandler = function(event) {
  if (!this.adjusting) {
    this.performLayout(event);
  }
};


/**
 * Whenever children are added, listeners are added to detect changes
 * in their size. 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.ContainerView.prototype.childrenChangedHandler = function(event) {
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase);
  host.removeEventListener(event.type, org.apache.flex.utils.Language.closure(this.childrenChangedHandler, this, 'childrenChangedHandler'));
  var /** @type {number} */ n = this.contentView.numElements;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {org.apache.flex.core.IUIBase} */ child = org.apache.flex.utils.Language.as(this.contentView.getElementAt(i), org.apache.flex.core.IUIBase);
    child.addEventListener("widthChanged", org.apache.flex.utils.Language.closure(this.childResizeHandler, this, 'childResizeHandler'));
    child.addEventListener("heightChanged", org.apache.flex.utils.Language.closure(this.childResizeHandler, this, 'childResizeHandler'));
    child.addEventListener("sizeChanged", org.apache.flex.utils.Language.closure(this.childResizeHandler, this, 'childResizeHandler'));
  }
};


/**
 * This event handles changes to the size of children of the container by running
 * the layout again and adjusting the size of the container or viewport as necessary. 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.ContainerView.prototype.childResizeHandler = function(event) {
  if (this.layoutRunning)
    return;
  this.performLayout(event);
};


/**
 * @protected
 * @param {org.apache.flex.core.UIBase} host
 */
org.apache.flex.html.beads.ContainerView.prototype.displayBackgroundAndBorder = function(host) {
  var /** @type {Object} */ backgroundColor = org.apache.flex.core.ValuesManager.valuesImpl.getValue(host, "background-color");
  var /** @type {Object} */ backgroundImage = org.apache.flex.core.ValuesManager.valuesImpl.getValue(host, "background-image");
  if (backgroundColor != null || backgroundImage != null) {
    if (host.getBeadByType(org.apache.flex.html.beads.IBackgroundBead) == null)
      var /** @type {Object} */ c = org.apache.flex.core.ValuesManager.valuesImpl.getValue(host, "iBackgroundBead");
    if (c) {
      host.addBead(org.apache.flex.utils.Language.as(new c(), org.apache.flex.core.IBead));
    }
  }
  var /** @type {string} */ borderStyle;
  var /** @type {Object} */ borderStyles = org.apache.flex.core.ValuesManager.valuesImpl.getValue(host, "border");
  if (org.apache.flex.utils.Language.is(borderStyles, Array)) {
    borderStyle = org.apache.flex.utils.Language.string(borderStyles[1]);
  }
  if (borderStyle == null) {
    borderStyle = org.apache.flex.utils.Language.as(org.apache.flex.core.ValuesManager.valuesImpl.getValue(host, "border-style"), String);
  }
  if (borderStyle != null && borderStyle != "none") {
    if (host.getBeadByType(org.apache.flex.html.beads.IBorderBead) == null) {
      c = org.apache.flex.core.ValuesManager.valuesImpl.getValue(host, "iBorderBead");
      if (c) {
        host.addBead(org.apache.flex.utils.Language.as(new c(), org.apache.flex.core.IBead));
      }
    }
  }
};


Object.defineProperties(org.apache.flex.html.beads.ContainerView.prototype, /** @lends {org.apache.flex.html.beads.ContainerView.prototype} */ {
/** @export */
contentView: {
get: /** @this {org.apache.flex.html.beads.ContainerView} */ function() {
  return org.apache.flex.utils.Language.as(this.viewport.contentView, org.apache.flex.core.IParentIUIBase);
}},
/** @export */
resizableView: {
get: /** @this {org.apache.flex.html.beads.ContainerView} */ function() {
  return this.host;
}},
/** @export */
viewport: {
get: /** @this {org.apache.flex.html.beads.ContainerView} */ function() {
  return this._viewport;
}},
/** @export */
viewportModel: {
get: /** @this {org.apache.flex.html.beads.ContainerView} */ function() {
  return this._viewportModel;
}},
/** @export */
numElements: {
get: /** @this {org.apache.flex.html.beads.ContainerView} */ function() {
  return this.contentView.numElements;
}},
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.ContainerView} */ function(value) {
  this._strand = value;
  org.apache.flex.utils.Language.superSetter(org.apache.flex.html.beads.ContainerView, this, 'strand', value);
  this.createViewport();
  org.apache.flex.utils.Language.as(this.host, org.apache.flex.core.IContentViewHost).strandChildren.addElement(this.viewport.contentView, false);
  this.displayBackgroundAndBorder(org.apache.flex.utils.Language.as(this.host, org.apache.flex.core.UIBase));
  this.host.addEventListener("initComplete", org.apache.flex.utils.Language.closure(this.initCompleteHandler, this, 'initCompleteHandler'));
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.ContainerView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ContainerView', qName: 'org.apache.flex.html.beads.ContainerView'}], interfaces: [org.apache.flex.core.IBeadView, org.apache.flex.core.IContainerView, org.apache.flex.core.ILayoutHost] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.ContainerView', org.apache.flex.html.beads.ContainerView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.ContainerView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'contentView': { type: 'IParentIUIBase', declaredBy: 'org.apache.flex.html.beads.ContainerView'},
        'resizableView': { type: 'IUIBase', declaredBy: 'org.apache.flex.html.beads.ContainerView'},
        'viewportModel': { type: 'IViewportModel', declaredBy: 'org.apache.flex.html.beads.ContainerView'},
        'numElements': { type: 'int', declaredBy: 'org.apache.flex.html.beads.ContainerView'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.ContainerView'}
      };
    },
    methods: function () {
      return {
        'ContainerView': { type: '', declaredBy: 'org.apache.flex.html.beads.ContainerView'},
        'addElement': { type: 'void', declaredBy: 'org.apache.flex.html.beads.ContainerView'},
        'addElementAt': { type: 'void', declaredBy: 'org.apache.flex.html.beads.ContainerView'},
        'getElementIndex': { type: 'int', declaredBy: 'org.apache.flex.html.beads.ContainerView'},
        'removeElement': { type: 'void', declaredBy: 'org.apache.flex.html.beads.ContainerView'},
        'getElementAt': { type: 'Object', declaredBy: 'org.apache.flex.html.beads.ContainerView'}
      };
    }
  };
};