/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/WebBrowser.as
 * org.apache.flex.html.WebBrowser
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.WebBrowser');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.html.beads.models.WebBrowserModel');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 */
org.apache.flex.html.WebBrowser = function() {
  org.apache.flex.html.WebBrowser.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.WebBrowser, org.apache.flex.core.UIBase);


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.flex.html.WebBrowser.prototype.createElement = function() {
  this.element = document.createElement('iframe');
  this.element.flexjs_wrapper = this;
  var /** @type {HTMLIFrameElement} */ iframe = org.apache.flex.utils.Language.as(this.element, HTMLIFrameElement);
  iframe.frameBorder = "0";
  iframe.src = "JavaScript:''";
  iframe.sandbox = "allow-top-navigation allow-forms allow-scripts";
  this.positioner = this.element;
  return this.element;
};


Object.defineProperties(org.apache.flex.html.WebBrowser.prototype, /** @lends {org.apache.flex.html.WebBrowser.prototype} */ {
/** @export */
url: {
get: /** @this {org.apache.flex.html.WebBrowser} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.html.beads.models.WebBrowserModel).url;
},
set: /** @this {org.apache.flex.html.WebBrowser} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.html.beads.models.WebBrowserModel).url = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.WebBrowser.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'WebBrowser', qName: 'org.apache.flex.html.WebBrowser'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.WebBrowser', org.apache.flex.html.WebBrowser);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.WebBrowser.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'url': { type: 'String', declaredBy: 'org.apache.flex.html.WebBrowser'}
      };
    },
    methods: function () {
      return {
        'WebBrowser': { type: '', declaredBy: 'org.apache.flex.html.WebBrowser'}
      };
    }
  };
};