/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/TitleBar.as
 * org.apache.flex.html.TitleBar
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.TitleBar');

goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.html.Container');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IBeadLayout');
goog.require('org.apache.flex.core.IChrome');
goog.require('org.apache.flex.core.ITitleBarModel');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.Container}
 * @implements {org.apache.flex.core.IChrome}
 */
org.apache.flex.html.TitleBar = function() {
  org.apache.flex.html.TitleBar.base(this, 'constructor');
  this.className = "TitleBar";
};
goog.inherits(org.apache.flex.html.TitleBar, org.apache.flex.html.Container);


/**
 * @asprivate
 * @export
 * @override
 */
org.apache.flex.html.TitleBar.prototype.addedToParent = function() {
  org.apache.flex.html.TitleBar.base(this, 'addedToParent');
  if (this.getBeadByType(org.apache.flex.core.IBeadLayout) == null)
    this.addBead(org.apache.flex.utils.Language.as(new (org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "iBeadLayout"))(), org.apache.flex.core.IBead));
};


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.flex.html.TitleBar.prototype.createElement = function() {
  this.element = document.createElement('div');
  this.positioner = this.element;
  this.positioner.style.position = 'relative';
  this.element.flexjs_wrapper = this;
  this.className = 'TitleBar';
  return this.element;
};


Object.defineProperties(org.apache.flex.html.TitleBar.prototype, /** @lends {org.apache.flex.html.TitleBar.prototype} */ {
/** @export */
title: {
get: /** @this {org.apache.flex.html.TitleBar} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ITitleBarModel, true).title;
},
set: /** @this {org.apache.flex.html.TitleBar} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ITitleBarModel, true).title = value;
}},
/** @export */
htmlTitle: {
get: /** @this {org.apache.flex.html.TitleBar} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ITitleBarModel, true).htmlTitle;
},
set: /** @this {org.apache.flex.html.TitleBar} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ITitleBarModel, true).htmlTitle = value;
}},
/** @export */
showCloseButton: {
get: /** @this {org.apache.flex.html.TitleBar} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ITitleBarModel, true).showCloseButton;
},
set: /** @this {org.apache.flex.html.TitleBar} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ITitleBarModel, true).showCloseButton = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.TitleBar.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'TitleBar', qName: 'org.apache.flex.html.TitleBar'}], interfaces: [org.apache.flex.core.IChrome] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.TitleBar', org.apache.flex.html.TitleBar);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.TitleBar.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'title': { type: 'String', declaredBy: 'org.apache.flex.html.TitleBar'},
        'htmlTitle': { type: 'String', declaredBy: 'org.apache.flex.html.TitleBar'},
        'showCloseButton': { type: 'Boolean', declaredBy: 'org.apache.flex.html.TitleBar'}
      };
    },
    methods: function () {
      return {
        'TitleBar': { type: '', declaredBy: 'org.apache.flex.html.TitleBar'},
        'addedToParent': { type: 'void', declaredBy: 'org.apache.flex.html.TitleBar'}
      };
    }
  };
};