/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/RadioButton.as
 * org.apache.flex.html.RadioButton
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.RadioButton');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.html.supportClasses.RadioButtonIcon');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 */
org.apache.flex.html.RadioButton = function() {
  org.apache.flex.html.RadioButton.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.RadioButton, org.apache.flex.core.UIBase);


/**
 * @export
 * @type {number}
 */
org.apache.flex.html.RadioButton.radioCounter = 0;


/**
 * @private
 * @type {HTMLLabelElement}
 */
org.apache.flex.html.RadioButton.prototype.labelFor;


/**
 * @private
 * @type {Text}
 */
org.apache.flex.html.RadioButton.prototype.textNode;


/**
 * @private
 * @type {org.apache.flex.html.supportClasses.RadioButtonIcon}
 */
org.apache.flex.html.RadioButton.prototype.icon;


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @flexjsignorecoercion HTMLInputElement
 * @flexjsignorecoercion HTMLLabelElement
 * @flexjsignorecoercion Text
 * @protected
 * @override
 */
org.apache.flex.html.RadioButton.prototype.createElement = function() {
  this.icon = new org.apache.flex.html.supportClasses.RadioButtonIcon();
  this.icon.id = '_radio_' + org.apache.flex.html.RadioButton.radioCounter++;
  this.textNode = document.createTextNode('radio button');
  this.labelFor = document.createElement('label');
  this.labelFor.appendChild(this.icon.element);
  this.labelFor.appendChild(this.textNode);
  this.element = this.labelFor;
  this.positioner = this.element;
  this.positioner.style.position = 'relative';
  this.element.flexjs_wrapper = this;
  this.textNode.flexjs_wrapper = this;
  this.icon.element.flexjs_wrapper = this;
  this.className = 'RadioButton';
  this.typeNames = 'RadioButton, RadioButtonIcon';
  return this.element;
};


Object.defineProperties(org.apache.flex.html.RadioButton.prototype, /** @lends {org.apache.flex.html.RadioButton.prototype} */ {
/** @export */
id: {
get: /** @this {org.apache.flex.html.RadioButton} */ function() {
return org.apache.flex.utils.Language.superGetter(org.apache.flex.html.RadioButton, this, 'id');
},
set: /** @this {org.apache.flex.html.RadioButton} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.html.RadioButton, this, 'id', value);
  this.labelFor.id = value;
  this.icon.element.id = value;
}},
/** @export */
groupName: {
get: /** @this {org.apache.flex.html.RadioButton} */ function() {
  return org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(this.icon.element, HTMLInputElement).name, String);
},
set: /** @this {org.apache.flex.html.RadioButton} */ function(value) {
  org.apache.flex.utils.Language.as(this.icon.element, HTMLInputElement).name = value;
}},
/** @export */
text: {
get: /** @this {org.apache.flex.html.RadioButton} */ function() {
  return org.apache.flex.utils.Language.as(this.textNode.nodeValue, String);
},
set: /** @this {org.apache.flex.html.RadioButton} */ function(value) {
  this.textNode.nodeValue = value;
}},
/** @export */
selected: {
get: /** @this {org.apache.flex.html.RadioButton} */ function() {
  return org.apache.flex.utils.Language.as(this.icon.element, HTMLInputElement).checked;
},
set: /** @this {org.apache.flex.html.RadioButton} */ function(value) {
  org.apache.flex.utils.Language.as(this.icon.element, HTMLInputElement).checked = value;
}},
/** @export */
value: {
get: /** @this {org.apache.flex.html.RadioButton} */ function() {
  return org.apache.flex.utils.Language.as(this.icon.element, HTMLInputElement).value;
},
set: /** @this {org.apache.flex.html.RadioButton} */ function(v) {
  org.apache.flex.utils.Language.as(this.icon.element, HTMLInputElement).value = org.apache.flex.utils.Language.as(v, String);
}},
/** @export */
selectedValue: {
get: /** @this {org.apache.flex.html.RadioButton} */ function() {
  var /** @type {NodeList} */ buttons;
  var /** @type {string} */ groupName;
  var /** @type {number} */ i;
  var /** @type {number} */ n;
  groupName = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(this.icon.element, HTMLInputElement).name, String);
  buttons = document.getElementsByName(groupName);
  n = buttons.length;
  for (i = 0; i < n; i++) {
    if (buttons[i].checked) {
      return buttons[i].value;
    }
  }
  return null;
},
set: /** @this {org.apache.flex.html.RadioButton} */ function(value) {
  var /** @type {NodeList} */ buttons;
  var /** @type {string} */ groupName;
  var /** @type {number} */ i;
  var /** @type {number} */ n;
  groupName = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(this.icon.element, HTMLInputElement).name, String);
  buttons = document.getElementsByName(groupName);
  n = buttons.length;
  for (i = 0; i < n; i++) {
    if (buttons[i].value === value) {
      buttons[i].checked = true;
      break;
    }
  }
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.RadioButton.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'RadioButton', qName: 'org.apache.flex.html.RadioButton'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.RadioButton', org.apache.flex.html.RadioButton);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.RadioButton.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'id': { type: 'String', declaredBy: 'org.apache.flex.html.RadioButton'},
        'groupName': { type: 'String', declaredBy: 'org.apache.flex.html.RadioButton'},
        'text': { type: 'String', declaredBy: 'org.apache.flex.html.RadioButton'},
        'selected': { type: 'Boolean', declaredBy: 'org.apache.flex.html.RadioButton'},
        'value': { type: 'Object', declaredBy: 'org.apache.flex.html.RadioButton'},
        'selectedValue': { type: 'Object', declaredBy: 'org.apache.flex.html.RadioButton'}
      };
    },
    methods: function () {
      return {
      };
    }
  };
};