/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/CheckBox.as
 * org.apache.flex.html.CheckBox
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.CheckBox');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.html.supportClasses.CheckBoxIcon');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 */
org.apache.flex.html.CheckBox = function() {
  org.apache.flex.html.CheckBox.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.CheckBox, org.apache.flex.core.UIBase);


/**
 * @private
 * @type {org.apache.flex.core.WrappedHTMLElement}
 */
org.apache.flex.html.CheckBox.prototype._label;


/**
 * @private
 * @type {org.apache.flex.html.supportClasses.CheckBoxIcon}
 */
org.apache.flex.html.CheckBox.prototype._icon;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.CheckBox._checkNumber = 0;


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.flex.html.CheckBox.prototype.createElement = function() {
  var /** @type {HTMLInputElement} */ cb;
  this.element = document.createElement('label');
  this._label = this.element;
  this._icon = new org.apache.flex.html.supportClasses.CheckBoxIcon();
  this.element.appendChild(this._icon.element);
  this.element.appendChild(document.createTextNode(''));
  this.positioner = this.element;
  this.positioner.style.position = 'relative';
  this.element.flexjs_wrapper = this;
  this._icon.element.flexjs_wrapper = this;
  this.className = 'CheckBox';
  this.typeNames = 'CheckBox, CheckBoxIcon';
  return this.element;
};


Object.defineProperties(org.apache.flex.html.CheckBox.prototype, /** @lends {org.apache.flex.html.CheckBox.prototype} */ {
/** @export */
text: {
get: /** @this {org.apache.flex.html.CheckBox} */ function() {
  return this._label.childNodes.item(1).nodeValue;
},
set: /** @this {org.apache.flex.html.CheckBox} */ function(value) {
  this._label.childNodes.item(1).nodeValue = value;
}},
/** @export */
selected: {
get: /** @this {org.apache.flex.html.CheckBox} */ function() {
  return org.apache.flex.utils.Language.as(this._icon.element, HTMLInputElement).checked;
},
set: /** @this {org.apache.flex.html.CheckBox} */ function(value) {
  org.apache.flex.utils.Language.as(this._icon.element, HTMLInputElement).checked = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.CheckBox.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'CheckBox', qName: 'org.apache.flex.html.CheckBox'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.CheckBox', org.apache.flex.html.CheckBox);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.CheckBox.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'text': { type: 'String', declaredBy: 'org.apache.flex.html.CheckBox'},
        'selected': { type: 'Boolean', declaredBy: 'org.apache.flex.html.CheckBox'}
      };
    },
    methods: function () {
      return {
      };
    }
  };
};