/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/graphics/LineTo.as
 * org.apache.flex.graphics.LineTo
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.graphics.LineTo');

goog.require('org.apache.flex.graphics.IPathCommand');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @implements {org.apache.flex.graphics.IPathCommand}
 * @param {number} x
 * @param {number} y
 */
org.apache.flex.graphics.LineTo = function(x, y) {
  this._x = x;
  this._y = y;
};


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.LineTo.prototype._x;


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.LineTo.prototype._y;


/**
 * @export
 * @return {string}
 */
org.apache.flex.graphics.LineTo.prototype.toString = function() {
  return ["L", this._x, this._y].join(" ");
};


/**
 * @export
 * @param {Object} ctx
 */
org.apache.flex.graphics.LineTo.prototype.execute = function(ctx) {
  ctx.lineTo(this._x, this._y);
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.graphics.LineTo.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'LineTo', qName: 'org.apache.flex.graphics.LineTo'}], interfaces: [org.apache.flex.graphics.IPathCommand] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.graphics.LineTo', org.apache.flex.graphics.LineTo);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.graphics.LineTo.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'LineTo': { type: '', declaredBy: 'org.apache.flex.graphics.LineTo'},
        'toString': { type: 'String', declaredBy: 'org.apache.flex.graphics.LineTo'},
        'execute': { type: 'void', declaredBy: 'org.apache.flex.graphics.LineTo'}
      };
    }
  };
};