/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/effects/PlatformWiper.as
 * org.apache.flex.effects.PlatformWiper
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.effects.PlatformWiper');

goog.require('org.apache.flex.geom.Rectangle');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @constructor
 */
org.apache.flex.effects.PlatformWiper = function() {
  ;
};


/**
 * @private
 * @type {org.apache.flex.core.IUIBase}
 */
org.apache.flex.effects.PlatformWiper.prototype._target;


/**
 * @private
 * @type {string}
 */
org.apache.flex.effects.PlatformWiper.prototype._overflow;


Object.defineProperties(org.apache.flex.effects.PlatformWiper.prototype, /** @lends {org.apache.flex.effects.PlatformWiper.prototype} */ {
/** @export */
target: {
set: /** @this {org.apache.flex.effects.PlatformWiper} */ function(value) {
  
  if (value == null) {
    if (this._overflow == null)
      delete this._target.positioner.style["overflow"];
    else
      this._target.positioner.style.overflow = this._overflow;
  }
  this._target = value;
  if (value != null) {
    this._overflow = this._target.positioner.style.overflow;
  }
}},
/** @export */
visibleRect: {
set: /** @this {org.apache.flex.effects.PlatformWiper} */ function(value) {
  
  this._target.positioner.style.height = value.height.toString() + 'px';
  this._target.positioner.style.overflow = 'hidden';
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.effects.PlatformWiper.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'PlatformWiper', qName: 'org.apache.flex.effects.PlatformWiper'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.effects.PlatformWiper', org.apache.flex.effects.PlatformWiper);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.effects.PlatformWiper.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'target': { type: 'IUIBase', declaredBy: 'org.apache.flex.effects.PlatformWiper'},
        'visibleRect': { type: 'org.apache.flex.geom.Rectangle', declaredBy: 'org.apache.flex.effects.PlatformWiper'}
      };
    },
    methods: function () {
      return {
        'PlatformWiper': { type: '', declaredBy: 'org.apache.flex.effects.PlatformWiper'}
      };
    }
  };
};