/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/createjs/tween/Ease.as
 * org.apache.flex.createjs.tween.Ease
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.createjs.tween.Ease');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @constructor
 */
org.apache.flex.createjs.tween.Ease = function() {
};


/**
 * Mimics the simple -100 to 100 easing in Flash Pro.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} value
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.get = function(value) {
  
  return createjs.Ease.get(value);
};


/**
 * Configurable exponential ease.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} value
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.getPowIn = function(value) {
  
  return createjs.Ease.getPowIn(value);
};


/**
 * Configurable exponential ease.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} value
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.getPowOut = function(value) {
  
  return createjs.Ease.getPowOut(value);
};


/**
 * Configurable exponential ease.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} value
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.getPowInOut = function(value) {
  
  return createjs.Ease.getPowInOut(value);
};


/**
 * @method quadIn
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.quadIn = function() {
  return org.apache.flex.createjs.tween.Ease.getPowIn(2);
};


/**
 * @method quadOut
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.quadOut = function() {
  return org.apache.flex.createjs.tween.Ease.getPowOut(2);
};


/**
 * @method quadInOut
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.quadInOut = function() {
  return org.apache.flex.createjs.tween.Ease.getPowInOut(2);
};


/**
 * @method cubicIn
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.cubicIn = function() {
  return org.apache.flex.createjs.tween.Ease.getPowIn(3);
};


/**
 * @method cubicOut
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.cubicOut = function() {
  return org.apache.flex.createjs.tween.Ease.getPowOut(3);
};


/**
 * @method cubicInOut
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.cubicInOut = function() {
  return org.apache.flex.createjs.tween.Ease.getPowInOut(3);
};


/**
 * @method quartIn
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.quartIn = function() {
  return org.apache.flex.createjs.tween.Ease.getPowIn(4);
};


/**
 * @method quartOut
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.quartOut = function() {
  return org.apache.flex.createjs.tween.Ease.getPowOut(4);
};


/**
 * @method quartInOut
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.quartInOut = function() {
  return org.apache.flex.createjs.tween.Ease.getPowInOut(4);
};


/**
 * @method quintIn
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.quintIn = function() {
  return org.apache.flex.createjs.tween.Ease.getPowIn(5);
};


/**
 * @method quintOut
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.quintOut = function() {
  return org.apache.flex.createjs.tween.Ease.getPowOut(5);
};


/**
 * @method quintInOut
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.quintInOut = function() {
  return org.apache.flex.createjs.tween.Ease.getPowInOut(5);
};


/**
 * @method sineIn
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} t
 * @return {number}
 */
org.apache.flex.createjs.tween.Ease.sineIn = function(t) {
  return 1 - Math.cos(t * Math.PI / 2);
};


/**
 * @method sineOut
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} t
 * @return {number}
 */
org.apache.flex.createjs.tween.Ease.sineOut = function(t) {
  return Math.sin(t * Math.PI / 2);
};


/**
 * @method sineInOut
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} t
 * @return {number}
 */
org.apache.flex.createjs.tween.Ease.sineInOut = function(t) {
  return -0.5 * (Math.cos(Math.PI * t) - 1);
};


/**
 * Configurable "back in" ease.
 * @method getBackIn
 * @asparam {Number} amount The strength of the ease.
 * @static
 * @asreturn {Function}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} amount
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.getBackIn = function(amount) {
  var /** @type {Function} */ __localFn0__ = function(t) {
    return t * t * ((amount + 1) * t - amount);
  }
  return __localFn0__;
};


/**
 * @method backIn
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.backIn = function() {
  return org.apache.flex.createjs.tween.Ease.getBackIn(1.7);
};


/**
 * Configurable "back out" ease.
 * @method getBackOut
 * @asparam {Number} amount The strength of the ease.
 * @static
 * @asreturn {Function}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} amount
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.getBackOut = function(amount) {
  var /** @type {Function} */ __localFn0__ = function(t) {
    return (--t * t * ((amount + 1) * t + amount) + 1);
  }
  return __localFn0__;
};


/**
 * @method backOut
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.backOut = function() {
  return org.apache.flex.createjs.tween.Ease.getBackOut(1.7);
};


/**
 * Configurable "back in out" ease.
 * @method getBackInOut
 * @asparam {Number} amount The strength of the ease.
 * @static
 * @asreturn {Function}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} amount
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.getBackInOut = function(amount) {
  var /** @type {Function} */ __localFn0__ = function(t) {
    if ((t *= 2) < 1)
      return 0.5 * (t * t * ((amount + 1) * t - amount));
    return 0.5 * ((t -= 2) * t * ((amount + 1) * t + amount) + 2);
  }
  amount *= 1.525;
  return __localFn0__;
};


/**
 * @method backInOut
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.backInOut = function() {
  return org.apache.flex.createjs.tween.Ease.getBackInOut(1.7);
};


/**
 * @method circIn
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} t
 * @return {number}
 */
org.apache.flex.createjs.tween.Ease.circIn = function(t) {
  return -(Math.sqrt(1 - t * t) - 1);
};


/**
 * @method circOut
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} t
 * @return {number}
 */
org.apache.flex.createjs.tween.Ease.circOut = function(t) {
  return Math.sqrt(1 - (--t) * t);
};


/**
 * @method circInOut
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} t
 * @return {number}
 */
org.apache.flex.createjs.tween.Ease.circInOut = function(t) {
  if ((t *= 2) < 1)
    return -0.5 * (Math.sqrt(1 - t * t) - 1);
  return 0.5 * (Math.sqrt(1 - (t -= 2) * t) + 1);
};


/**
 * @method bounceIn
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} t
 * @return {number}
 */
org.apache.flex.createjs.tween.Ease.bounceIn = function(t) {
  return 1 - org.apache.flex.createjs.tween.Ease.bounceOut(1 - t);
};


/**
 * @method bounceOut
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} t
 * @return {number}
 */
org.apache.flex.createjs.tween.Ease.bounceOut = function(t) {
  if (t < 1 / 2.75) {
    return (7.5625 * t * t);
  } else if (t < 2 / 2.75) {
    return (7.5625 * (t -= 1.5 / 2.75) * t + 0.75);
  } else if (t < 2.5 / 2.75) {
    return (7.5625 * (t -= 2.25 / 2.75) * t + 0.9375);
  } else {
    return (7.5625 * (t -= 2.625 / 2.75) * t + 0.984375);
  }
};


/**
 * @method bounceInOut
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} t
 * @return {number}
 */
org.apache.flex.createjs.tween.Ease.bounceInOut = function(t) {
  if (t < 0.5)
    return org.apache.flex.createjs.tween.Ease.bounceIn(t * 2) * .5;
  return org.apache.flex.createjs.tween.Ease.bounceOut(t * 2 - 1) * 0.5 + 0.5;
};


/**
 * Configurable elastic ease.
 * @method getElasticIn
 * @asparam {Number} amplitude
 * @asparam {Number} period
 * @static
 * @asreturn {Function}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} amplitude
 * @param {number} period
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.getElasticIn = function(amplitude, period) {
  var /** @type {Function} */ __localFn0__ = function(t) {
    if (t == 0 || t == 1)
      return t;
    var /** @type {number} */ s = period / pi2 * Math.asin(1 / amplitude);
    return -(amplitude * Math.pow(2, 10 * (t -= 1)) * Math.sin((t - s) * pi2 / period));
  }
  var /** @type {number} */ pi2 = Math.PI * 2;
  return __localFn0__;
};


/**
 * @method elasticIn
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.elasticIn = function() {
  return org.apache.flex.createjs.tween.Ease.getElasticIn(1, 0.3);
};


/**
 * Configurable elastic ease.
 * @method getElasticOut
 * @asparam {Number} amplitude
 * @asparam {Number} period
 * @static
 * @asreturn {Function}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} amplitude
 * @param {number} period
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.getElasticOut = function(amplitude, period) {
  var /** @type {Function} */ __localFn0__ = function(t) {
    if (t == 0 || t == 1)
      return t;
    var /** @type {number} */ s = period / pi2 * Math.asin(1 / amplitude);
    return (amplitude * Math.pow(2, -10 * t) * Math.sin((t - s) * pi2 / period) + 1);
  }
  var /** @type {number} */ pi2 = Math.PI * 2;
  return __localFn0__;
};


/**
 * @method elasticOut
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.elasticOut = function() {
  return org.apache.flex.createjs.tween.Ease.getElasticOut(1, 0.3);
};


/**
 * Configurable elastic ease.
 * @method getElasticInOut
 * @asparam {Number} amplitude
 * @asparam {Number} period
 * @static
 * @asreturn {Function}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} amplitude
 * @param {number} period
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.getElasticInOut = function(amplitude, period) {
  var /** @type {Function} */ __localFn0__ = function(t) {
    var /** @type {number} */ s = period / pi2 * Math.asin(1 / amplitude);
    if ((t *= 2) < 1)
      return -0.5 * (amplitude * Math.pow(2, 10 * (t -= 1)) * Math.sin((t - s) * pi2 / period));
    return amplitude * Math.pow(2, -10 * (t -= 1)) * Math.sin((t - s) * pi2 / period) * 0.5 + 1;
  }
  var /** @type {number} */ pi2 = Math.PI * 2;
  return __localFn0__;
};


/**
 * @method elasticInOut
 * @asparam {Number} t
 * @static
 * @asreturn {Number}
 * 
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @return {Function}
 */
org.apache.flex.createjs.tween.Ease.elasticInOut = function() {
  return org.apache.flex.createjs.tween.Ease.getElasticInOut(1, 0.3 * 1.5);
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.createjs.tween.Ease.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Ease', qName: 'org.apache.flex.createjs.tween.Ease'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.createjs.tween.Ease', org.apache.flex.createjs.tween.Ease);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.createjs.tween.Ease.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'Ease': { type: '', declaredBy: 'org.apache.flex.createjs.tween.Ease'}
      };
    }
  };
};