/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/createjs/graphics/Circle.as
 * org.apache.flex.createjs.graphics.Circle
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.createjs.graphics.Circle');

goog.require('org.apache.flex.createjs.graphics.GraphicShape');
goog.require('org.apache.flex.graphics.SolidColor');
goog.require('org.apache.flex.graphics.SolidColorStroke');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.createjs.graphics.GraphicShape}
 */
org.apache.flex.createjs.graphics.Circle = function() {
  org.apache.flex.createjs.graphics.Circle.base(this, 'constructor');
};
goog.inherits(org.apache.flex.createjs.graphics.Circle, org.apache.flex.createjs.graphics.GraphicShape);


/**
 * @private
 * @type {number}
 */
org.apache.flex.createjs.graphics.Circle.prototype._radius = 0;


/**
 * @asprivate
 * @flexjsignorecoercion createjs.Shape
 *
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion FlexJS 0.0
 * @protected
 * @override
 */
org.apache.flex.createjs.graphics.Circle.prototype.redrawShape = function() {
  var /** @type {string} */ fillColor = null;
  var /** @type {number} */ fillAlpha = 1.0;
  if (this.fill != null) {
    fillAlpha = org.apache.flex.utils.Language.as(this.fill, org.apache.flex.graphics.SolidColor).alpha;
    fillColor = this.convertColorToString(org.apache.flex.utils.Language.as(this.fill, org.apache.flex.graphics.SolidColor).color, fillAlpha);
  }
  var /** @type {string} */ strokeColor = null;
  var /** @type {number} */ strokeWeight = 0;
  var /** @type {number} */ strokeAlpha = 1.0;
  if (this.stroke != null) {
    strokeWeight = org.apache.flex.utils.Language.as(this.stroke, org.apache.flex.graphics.SolidColorStroke).weight;
    strokeAlpha = org.apache.flex.utils.Language.as(this.stroke, org.apache.flex.graphics.SolidColorStroke).alpha;
    strokeColor = this.convertColorToString(org.apache.flex.utils.Language.as(this.stroke, org.apache.flex.graphics.SolidColorStroke).color, strokeAlpha);
  }
  var /** @type {createjs.Shape} */ circle = this.element;
  circle.graphics.setStrokeStyle(strokeWeight);
  circle.graphics.beginStroke(strokeColor);
  circle.graphics.beginFill(fillColor);
  circle.graphics.drawCircle(0, 0, this.radius);
  var /** @type {createjs.Stage} */ stage = circle.getStage();
  if (stage)
    stage.update();
};


Object.defineProperties(org.apache.flex.createjs.graphics.Circle.prototype, /** @lends {org.apache.flex.createjs.graphics.Circle.prototype} */ {
/** @export */
radius: {
get: /** @this {org.apache.flex.createjs.graphics.Circle} */ function() {
  return this._radius;
},
set: /** @this {org.apache.flex.createjs.graphics.Circle} */ function(value) {
  if (value != this._radius) {
    var /** @type {number} */ centerX = org.apache.flex.utils.Language.superGetter(org.apache.flex.createjs.graphics.Circle, this, 'x') + this._radius;
    var /** @type {number} */ centerY = org.apache.flex.utils.Language.superGetter(org.apache.flex.createjs.graphics.Circle, this, 'y') + this._radius;
    this._radius = value;
    this.x = centerX;
    this.y = centerY;
    this.dispatchEvent(new Event("radiusChanged"));
  }
}},
/** @export */
x: {
get: /** @this {org.apache.flex.createjs.graphics.Circle} */ function() {
  var /** @type {number} */ realX = org.apache.flex.utils.Language.superGetter(org.apache.flex.createjs.graphics.Circle, this, 'x');
  return realX + this.radius;
},
set: /** @this {org.apache.flex.createjs.graphics.Circle} */ function(value) {
  var /** @type {number} */ realX = value - this.radius;
  org.apache.flex.utils.Language.superSetter(org.apache.flex.createjs.graphics.Circle, this, 'x', realX);
}},
/** @export */
y: {
get: /** @this {org.apache.flex.createjs.graphics.Circle} */ function() {
  var /** @type {number} */ realY = org.apache.flex.utils.Language.superGetter(org.apache.flex.createjs.graphics.Circle, this, 'y');
  return realY + this.radius;
},
set: /** @this {org.apache.flex.createjs.graphics.Circle} */ function(value) {
  var /** @type {number} */ realY = value - this.radius;
  org.apache.flex.utils.Language.superSetter(org.apache.flex.createjs.graphics.Circle, this, 'y', realY);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.createjs.graphics.Circle.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Circle', qName: 'org.apache.flex.createjs.graphics.Circle'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.createjs.graphics.Circle', org.apache.flex.createjs.graphics.Circle);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.createjs.graphics.Circle.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'radius': { type: 'Number', declaredBy: 'org.apache.flex.createjs.graphics.Circle'},
        'x': { type: 'Number', declaredBy: 'org.apache.flex.createjs.graphics.Circle'},
        'y': { type: 'Number', declaredBy: 'org.apache.flex.createjs.graphics.Circle'}
      };
    },
    methods: function () {
      return {
      };
    }
  };
};