/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/createjs/TextButton.as
 * org.apache.flex.createjs.TextButton
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.createjs.TextButton');

goog.require('org.apache.flex.createjs.core.CreateJSBase');
goog.require('org.apache.flex.graphics.SolidColor');
goog.require('org.apache.flex.core.ITextModel');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.createjs.core.CreateJSBase}
 */
org.apache.flex.createjs.TextButton = function() {
  org.apache.flex.createjs.TextButton.base(this, 'constructor');
};
goog.inherits(org.apache.flex.createjs.TextButton, org.apache.flex.createjs.core.CreateJSBase);


/**
 * @private
 * @type {createjs.Shape}
 */
org.apache.flex.createjs.TextButton.prototype.buttonBackground;


/**
 * @private
 * @type {createjs.Text}
 */
org.apache.flex.createjs.TextButton.prototype.buttonLabel;


/**
 * @private
 * @type {createjs.Container}
 */
org.apache.flex.createjs.TextButton.prototype.button;


/**
 * @asprivate
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.flex.createjs.TextButton.prototype.createElement = function() {
  this.buttonBackground = new createjs.Shape(null);
  this.buttonBackground.name = 'background';
  this.buttonLabel = new createjs.Text('button');
  this.buttonLabel.name = 'label';
  this.buttonLabel.textAlign = 'center';
  this.buttonLabel.textBaseline = 'middle';
  this.button = new createjs.Container();
  this.button.name = 'button';
  this.button.addChild(this.buttonBackground);
  this.button.addChild(this.buttonLabel);
  this.positioner = this.element = this.button;
  this.element.flexjs_wrapper = this;
  return this.element;
};


/**
 * @private
 * @type {string}
 */
org.apache.flex.createjs.TextButton.prototype._fontName = "bold 18px Arial";


/**
 * @asprivate
 * @protected
 * @override
 */
org.apache.flex.createjs.TextButton.prototype.redrawShape = function() {
  if (isNaN(this.width) || isNaN(this.height))
    return;
  var /** @type {string} */ fillColor = null;
  var /** @type {number} */ fillAlpha = 1.0;
  if (this.fill != null) {
    fillAlpha = org.apache.flex.utils.Language.as(this.fill, org.apache.flex.graphics.SolidColor).alpha;
    fillColor = this.convertColorToString(org.apache.flex.utils.Language.as(this.fill, org.apache.flex.graphics.SolidColor).color, fillAlpha);
  }
  this.buttonBackground.graphics.beginFill(fillColor).drawRoundRect(0, 0, this.width, this.height, 8);
  var /** @type {string} */ color = null;
  if (this.textColor != null) {
    color = this.convertColorToString(org.apache.flex.utils.Language.as(this.textColor, org.apache.flex.graphics.SolidColor).color, 1.0);
  }
  this.buttonLabel.x = this.width / 2;
  this.buttonLabel.y = this.height / 2;
  this.buttonLabel.text = this.text;
  this.buttonLabel["font"] = this.fontName;
  this.buttonLabel["color"] = color;
};


Object.defineProperties(org.apache.flex.createjs.TextButton.prototype, /** @lends {org.apache.flex.createjs.TextButton.prototype} */ {
/** @export */
fontName: {
get: /** @this {org.apache.flex.createjs.TextButton} */ function() {
  return this._fontName;
},
set: /** @this {org.apache.flex.createjs.TextButton} */ function(value) {
  this._fontName = value;
  this.redrawShape();
}},
/** @export */
text: {
get: /** @this {org.apache.flex.createjs.TextButton} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ITextModel, true).text;
},
set: /** @this {org.apache.flex.createjs.TextButton} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ITextModel, true).text = value;
  this.redrawShape();
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.createjs.TextButton.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'TextButton', qName: 'org.apache.flex.createjs.TextButton'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.createjs.TextButton', org.apache.flex.createjs.TextButton);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.createjs.TextButton.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'fontName': { type: 'String', declaredBy: 'org.apache.flex.createjs.TextButton'},
        'text': { type: 'String', declaredBy: 'org.apache.flex.createjs.TextButton'}
      };
    },
    methods: function () {
      return {
      };
    }
  };
};