/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/core/UIBase.as
 * org.apache.flex.core.UIBase
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.core.UIBase');

goog.require('org.apache.flex.core.HTMLElementWrapper');
goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IBeadController');
goog.require('org.apache.flex.core.IBeadModel');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.core.IFlexJSElement');
goog.require('org.apache.flex.core.ILayoutChild');
goog.require('org.apache.flex.core.IMeasurementBead');
goog.require('org.apache.flex.core.IParentIUIBase');
goog.require('org.apache.flex.core.IStrandWithModel');
goog.require('org.apache.flex.core.IStyleableObject');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.HTMLElementWrapper}
 * @implements {org.apache.flex.core.IStrandWithModel}
 * @implements {org.apache.flex.events.IEventDispatcher}
 * @implements {org.apache.flex.core.IParentIUIBase}
 * @implements {org.apache.flex.core.IStyleableObject}
 * @implements {org.apache.flex.core.ILayoutChild}
 * @implements {org.apache.flex.core.IFlexJSElement}
 */
org.apache.flex.core.UIBase = function() {
  org.apache.flex.core.UIBase.base(this, 'constructor');
  
  this.createElement();
};
goog.inherits(org.apache.flex.core.UIBase, org.apache.flex.core.HTMLElementWrapper);


/**
 * @private
 * @type {number}
 */
org.apache.flex.core.UIBase.prototype._explicitWidth;


/**
 * @private
 * @type {number}
 */
org.apache.flex.core.UIBase.prototype._explicitHeight;


/**
 * @private
 * @type {number}
 */
org.apache.flex.core.UIBase.prototype._percentWidth;


/**
 * @private
 * @type {number}
 */
org.apache.flex.core.UIBase.prototype._percentHeight;


/**
 * @private
 * @type {number}
 */
org.apache.flex.core.UIBase.prototype._width;


/**
 * @private
 * @type {number}
 */
org.apache.flex.core.UIBase.prototype._height;


/**
 *  @copy org.apache.flex.core.ILayoutChild#setHeight
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} value
 * @param {boolean=} noEvent
 */
org.apache.flex.core.UIBase.prototype.setHeight = function(value, noEvent) {
  noEvent = typeof noEvent !== 'undefined' ? noEvent : false;
  if (this._height != value) {
    this._height = value;
    this.positioner.style.height = value.toString() + 'px';
    if (!noEvent)
      this.dispatchEvent(new org.apache.flex.events.Event("heightChanged"));
  }
};


/**
 *  @copy org.apache.flex.core.ILayoutChild#setWidth
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} value
 * @param {boolean=} noEvent
 */
org.apache.flex.core.UIBase.prototype.setWidth = function(value, noEvent) {
  noEvent = typeof noEvent !== 'undefined' ? noEvent : false;
  if (this._width != value) {
    this._width = value;
    this.positioner.style.width = value.toString() + 'px';
    if (!noEvent)
      this.dispatchEvent(new org.apache.flex.events.Event("widthChanged"));
  }
};


/**
 *  @copy org.apache.flex.core.ILayoutChild#setWidthAndHeight
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} newWidth
 * @param {number} newHeight
 * @param {boolean=} noEvent
 */
org.apache.flex.core.UIBase.prototype.setWidthAndHeight = function(newWidth, newHeight, noEvent) {
  noEvent = typeof noEvent !== 'undefined' ? noEvent : false;
  if (this._width != newWidth) {
    this._width = newWidth;
    this.positioner.style.width = newWidth.toString() + 'px';
    if (!noEvent)
      this.dispatchEvent(new org.apache.flex.events.Event("widthChanged"));
  }
  if (this._height != newHeight) {
    this._height = newHeight;
    this.positioner.style.height = newHeight.toString() + 'px';
    if (!noEvent)
      this.dispatchEvent(new org.apache.flex.events.Event("heightChanged"));
  }
  this.dispatchEvent(new org.apache.flex.events.Event("sizeChanged"));
};


/**
 *  @copy org.apache.flex.core.ILayoutChild#isWidthSizedToContent
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @return {boolean}
 */
org.apache.flex.core.UIBase.prototype.isWidthSizedToContent = function() {
  if (!isNaN(this._explicitWidth))
    return false;
  if (!isNaN(this._percentWidth))
    return false;
  var /** @type {*} */ left = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "left");
  var /** @type {*} */ right = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "right");
  return (left === undefined || right === undefined);
};


/**
 *  @copy org.apache.flex.core.ILayoutChild#isHeightSizedToContent
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @return {boolean}
 */
org.apache.flex.core.UIBase.prototype.isHeightSizedToContent = function() {
  if (!isNaN(this._explicitHeight))
    return false;
  if (!isNaN(this._percentHeight))
    return false;
  var /** @type {*} */ top = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "top");
  var /** @type {*} */ bottom = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "bottom");
  return (top === undefined || bottom === undefined);
};


/**
 * @private
 * @type {number}
 */
org.apache.flex.core.UIBase.prototype._x;


/**
 *  @copy org.apache.flex.core.ILayoutChild#setX
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} value
 */
org.apache.flex.core.UIBase.prototype.setX = function(value) {
  
  this.positioner.style.position = 'absolute';
  this.positioner.style.left = value.toString() + 'px';
};


/**
 * @private
 * @type {number}
 */
org.apache.flex.core.UIBase.prototype._y;


/**
 *  @copy org.apache.flex.core.ILayoutChild#setY
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} value
 */
org.apache.flex.core.UIBase.prototype.setY = function(value) {
  
  this.positioner.style.position = 'absolute';
  this.positioner.style.top = value.toString() + 'px';
};


/**
 * @private
 * @type {string}
 */
org.apache.flex.core.UIBase.prototype.displayStyleForLayout;


/**
 *  The display style is used for both visible
 *  and layout so is managed as a special case.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} value
 */
org.apache.flex.core.UIBase.prototype.setDisplayStyleForLayout = function(value) {
  if (this.positioner.style.display !== 'none')
    this.positioner.style.display = value;
  else
    this.displayStyleForLayout = value;
};


/**
 * @asreturn The array of children.
 * @flexjsignorecoercion Array
 * @export
 * @return {Array}
 */
org.apache.flex.core.UIBase.prototype.internalChildren = function() {
  return this.element.childNodes;
};


/**
 * @private
 * @type {org.apache.flex.core.IBeadView}
 */
org.apache.flex.core.UIBase.prototype._view;


/**
 * @private
 * @type {string}
 */
org.apache.flex.core.UIBase.prototype._id;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.core.UIBase.prototype._style;


/**
 * @export
 * @type {string}
 */
org.apache.flex.core.UIBase.prototype.typeNames;


/**
 * @private
 * @type {string}
 */
org.apache.flex.core.UIBase.prototype._className;


/**
 * @export
 * @type {Array}
 */
org.apache.flex.core.UIBase.prototype.beads;


/**
 *  @copy org.apache.flex.core.IStrand#addBead()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @override
 */
org.apache.flex.core.UIBase.prototype.addBead = function(bead) {
  if (!this._beads)
    this._beads = new Array();
  this._beads.push(bead);
  if (org.apache.flex.utils.Language.is(bead, org.apache.flex.core.IBeadModel))
    this._model = org.apache.flex.utils.Language.as(bead, org.apache.flex.core.IBeadModel);
  else if (org.apache.flex.utils.Language.is(bead, org.apache.flex.core.IBeadView))
    this._view = org.apache.flex.utils.Language.as(bead, org.apache.flex.core.IBeadView);
  bead.strand = this;
  if (org.apache.flex.utils.Language.is(bead, org.apache.flex.core.IBeadView)) {
    org.apache.flex.utils.Language.as(this, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event("viewChanged"));
  }
};


/**
 *  @copy org.apache.flex.core.IParent#addElement()
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} c
 * @param {boolean=} dispatchEvent
 */
org.apache.flex.core.UIBase.prototype.addElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  
  this.element.appendChild(c.positioner);
  c.addedToParent();
};


/**
 *  @copy org.apache.flex.core.IParent#addElementAt()
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} c
 * @param {number} index
 * @param {boolean=} dispatchEvent
 */
org.apache.flex.core.UIBase.prototype.addElementAt = function(c, index, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  
  var /** @type {Array} */ children = this.internalChildren();
  if (index >= children.length)
    this.addElement(c); else {
    this.element.insertBefore(c.positioner, children[index]);
    c.addedToParent();
  }
};


/**
 *  @copy org.apache.flex.core.IParent#getElementAt()
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} index
 * @return {Object}
 */
org.apache.flex.core.UIBase.prototype.getElementAt = function(index) {
  
  var /** @type {Array} */ children = this.internalChildren();
  return children[index].flexjs_wrapper;
};


/**
 *  @copy org.apache.flex.core.IParent#getElementIndex()
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} c
 * @return {number}
 */
org.apache.flex.core.UIBase.prototype.getElementIndex = function(c) {
  
  var /** @type {Array} */ children = this.internalChildren();
  var /** @type {number} */ n = children.length;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    if (children[i] == c.element)
      return i;
  }
  return -1;
};


/**
 *  @copy org.apache.flex.core.IParent#removeElement()
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} c
 * @param {boolean=} dispatchEvent
 */
org.apache.flex.core.UIBase.prototype.removeElement = function(c, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  
  this.element.removeChild(c.element);
};


/**
 *  The method called when added to a parent.  This is a good
 *  time to set up beads.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion Class
 *  @flexjsignorecoercion Number
 * @export
 */
org.apache.flex.core.UIBase.prototype.addedToParent = function() {
  var /** @type {Object} */ c;
  if (this.style)
    org.apache.flex.core.ValuesManager.valuesImpl.applyStyles(this, this.style);
  if (isNaN(this._explicitWidth) && isNaN(this._percentWidth)) {
    var /** @type {*} */ value = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "width");
    if (value !== undefined) {
      if (org.apache.flex.utils.Language.is(value, String)) {
        var /** @type {string} */ s = String(value);
        if (s.indexOf("%") != -1)
          this._percentWidth = Number(s.substring(0, s.length - 1)); else {
          if (s.indexOf("px") != -1)
            s = s.substring(0, s.length - 2);
          this._width = this._explicitWidth = Number(s);
        }
      }
      else
        this._width = this._explicitWidth = value;
    }
  }
  if (isNaN(this._explicitHeight) && isNaN(this._percentHeight)) {
    value = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "height");
    if (value !== undefined) {
      if (org.apache.flex.utils.Language.is(value, String)) {
        s = String(value);
        if (s.indexOf("%") != -1)
          this._percentHeight = Number(s.substring(0, s.length - 1)); else {
          if (s.indexOf("px") != -1)
            s = s.substring(0, s.length - 2);
          this._height = this._explicitHeight = Number(s);
        }
      }
      else
        this._height = this._explicitHeight = value;
    }
  }
  var foreachiter0_target = this.beads;
  for (var foreachiter0 in foreachiter0_target) 
  {
  var bead = foreachiter0_target[foreachiter0];
  
    this.addBead(bead);}
  
  if (this.getBeadByType(org.apache.flex.core.IBeadModel) == null) {
    c = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "iBeadModel");
    if (c) {
      var /** @type {org.apache.flex.core.IBeadModel} */ model = org.apache.flex.utils.Language.as(new c(), org.apache.flex.core.IBeadModel);
      if (model)
        this.addBead(model);
    }
  }
  if (this._view == null && this.getBeadByType(org.apache.flex.core.IBeadView) == null) {
    c = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "iBeadView");
    if (c) {
      var /** @type {org.apache.flex.core.IBeadView} */ view = org.apache.flex.utils.Language.as(new c(), org.apache.flex.core.IBeadView);
      if (view)
        this.addBead(view);
    }
  }
  if (this.getBeadByType(org.apache.flex.core.IBeadController) == null) {
    c = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "iBeadController");
    if (c) {
      var /** @type {org.apache.flex.core.IBeadController} */ controller = org.apache.flex.utils.Language.as(new c(), org.apache.flex.core.IBeadController);
      if (controller)
        this.addBead(controller);
    }
  }
  this.dispatchEvent(new org.apache.flex.events.Event("beadsAdded"));
};


/**
 * Rebroadcast an event from a sub component from the component.
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.core.UIBase.prototype.repeaterListener = function(event) {
  this.dispatchEvent(event);
};


/**
 * @private
 * @type {org.apache.flex.core.WrappedHTMLElement}
 */
org.apache.flex.core.UIBase.prototype._positioner;


/**
 * @asreturn The actual element to be parented.
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @return {Object}
 */
org.apache.flex.core.UIBase.prototype.createElement = function() {
  if (this.element == null)
    this.element = document.createElement('div');
  if (this.positioner == null)
    this.positioner = this.element;
  this.positioner.style.display = 'block';
  this.positioner.style.position = 'relative';
  this.element.flexjs_wrapper = this;
  return this.positioner;
};


/**
 * @asparam value The event containing new style properties.
 * @protected
 * @param {org.apache.flex.events.ValueChangeEvent} value
 */
org.apache.flex.core.UIBase.prototype.styleChangeHandler = function(value) {
  var /** @type {Object} */ newStyle = {};
  newStyle[value.propertyName] = value.newValue;
  org.apache.flex.core.ValuesManager.valuesImpl.applyStyles(this, newStyle);
};


Object.defineProperties(org.apache.flex.core.UIBase.prototype, /** @lends {org.apache.flex.core.UIBase.prototype} */ {
/** @export */
explicitWidth: {
get: /** @this {org.apache.flex.core.UIBase} */ function() {
  return this._explicitWidth;
},
set: /** @this {org.apache.flex.core.UIBase} */ function(value) {
  if (this._explicitWidth == value)
    return;
  if (!isNaN(value))
    this._percentWidth = NaN;
  this._explicitWidth = value;
  this.dispatchEvent(new org.apache.flex.events.Event("explicitWidthChanged"));
}},
/** @export */
explicitHeight: {
get: /** @this {org.apache.flex.core.UIBase} */ function() {
  return this._explicitHeight;
},
set: /** @this {org.apache.flex.core.UIBase} */ function(value) {
  if (this._explicitHeight == value)
    return;
  if (!isNaN(value))
    this._percentHeight = NaN;
  this._explicitHeight = value;
  this.dispatchEvent(new org.apache.flex.events.Event("explicitHeightChanged"));
}},
/** @export */
percentWidth: {
get: /** @this {org.apache.flex.core.UIBase} */ function() {
  return this._percentWidth;
},
set: /** @this {org.apache.flex.core.UIBase} */ function(value) {
  
  this._percentWidth = value;
  this.positioner.style.width = value.toString() + '%';
  if (!isNaN(value))
    this._explicitWidth = NaN;
  this.dispatchEvent(new org.apache.flex.events.Event("percentWidthChanged"));
}},
/** @export */
percentHeight: {
get: /** @this {org.apache.flex.core.UIBase} */ function() {
  return this._percentHeight;
},
set: /** @this {org.apache.flex.core.UIBase} */ function(value) {
  
  this._percentHeight = value;
  this.positioner.style.height = value.toString() + '%';
  if (!isNaN(value))
    this._explicitHeight = NaN;
  this.dispatchEvent(new org.apache.flex.events.Event("percentHeightChanged"));
}},
/** @export */
width: {
get: /** @this {org.apache.flex.core.UIBase} */ function() {
  var /** @type {number} */ pixels;
  var /** @type {string} */ strpixels = this.positioner.style.width;
  if (strpixels !== null && strpixels.indexOf('%') != -1)
    pixels = NaN;
  else
    pixels = parseFloat(strpixels);
  if (isNaN(pixels)) {
    pixels = this.positioner.offsetWidth;
    if (pixels === 0 && this.positioner.scrollWidth !== 0) {
      pixels = this.positioner.scrollWidth;
    }
  }
  return pixels;
},
set: /** @this {org.apache.flex.core.UIBase} */ function(value) {
  if (this.explicitWidth != value) {
    this.explicitWidth = value;
  }
  this.setWidth(value);
}},
/** @export */
height: {
get: /** @this {org.apache.flex.core.UIBase} */ function() {
  var /** @type {number} */ pixels;
  var /** @type {string} */ strpixels = this.positioner.style.height;
  if (strpixels !== null && strpixels.indexOf('%') != -1)
    pixels = NaN;
  else
    pixels = parseFloat(strpixels);
  if (isNaN(pixels)) {
    pixels = this.positioner.offsetHeight;
    if (pixels === 0 && this.positioner.scrollHeight !== 0) {
      pixels = this.positioner.scrollHeight;
    }
  }
  return pixels;
},
set: /** @this {org.apache.flex.core.UIBase} */ function(value) {
  if (this.explicitHeight != value) {
    this.explicitHeight = value;
  }
  this.setHeight(value);
}},
/** @export */
x: {
get: /** @this {org.apache.flex.core.UIBase} */ function() {
  var /** @type {string} */ strpixels = this.positioner.style.left;
  var /** @type {number} */ pixels = parseFloat(strpixels);
  if (isNaN(pixels))
    pixels = this.positioner.offsetLeft;
  return pixels;
},
set: /** @this {org.apache.flex.core.UIBase} */ function(value) {
  this.positioner.style.position = 'absolute';
  this.positioner.style.left = value.toString() + 'px';
}},
/** @export */
y: {
get: /** @this {org.apache.flex.core.UIBase} */ function() {
  var /** @type {string} */ strpixels = this.positioner.style.top;
  var /** @type {number} */ pixels = parseFloat(strpixels);
  if (isNaN(pixels))
    pixels = this.positioner.offsetTop;
  return pixels;
},
set: /** @this {org.apache.flex.core.UIBase} */ function(value) {
  this.positioner.style.position = 'absolute';
  this.positioner.style.top = value.toString() + 'px';
}},
/** @export */
visible: {
get: /** @this {org.apache.flex.core.UIBase} */ function() {
  return this.positioner.style.display !== 'none';
},
set: /** @this {org.apache.flex.core.UIBase} */ function(value) {
  var /** @type {boolean} */ oldValue = this.positioner.style.display !== 'none';
  if (value !== oldValue) {
    if (!value) {
      this.displayStyleForLayout = this.positioner.style.display;
      this.positioner.style.display = 'none';
      this.dispatchEvent(new org.apache.flex.events.Event('hide'));
    } else {
      if (this.displayStyleForLayout)
        this.positioner.style.display = this.displayStyleForLayout;
      this.dispatchEvent(new org.apache.flex.events.Event('show'));
    }
    this.dispatchEvent(new org.apache.flex.events.Event('visibleChanged'));
  }
}},
/** @export */
view: {
get: /** @this {org.apache.flex.core.UIBase} */ function() {
  if (this._view == null) {
    var /** @type {Object} */ c = org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "iBeadView");
    if (c) {
      if (c) {
        this._view = org.apache.flex.utils.Language.as(new c(), org.apache.flex.core.IBeadView);
        this.addBead(this._view);
      }
    }
  }
  return this._view;
},
set: /** @this {org.apache.flex.core.UIBase} */ function(value) {
  if (this._view != value) {
    this.addBead(org.apache.flex.utils.Language.as(value, org.apache.flex.core.IBead));
    this.dispatchEvent(new org.apache.flex.events.Event("viewChanged"));
  }
}},
/** @export */
id: {
get: /** @this {org.apache.flex.core.UIBase} */ function() {
  return this._id;
},
set: /** @this {org.apache.flex.core.UIBase} */ function(value) {
  if (this._id != value) {
    this._id = value;
    this.dispatchEvent(new org.apache.flex.events.Event("idChanged"));
  }
}},
/** @export */
style: {
get: /** @this {org.apache.flex.core.UIBase} */ function() {
  return this._style;
},
set: /** @this {org.apache.flex.core.UIBase} */ function(value) {
  if (this._style != value) {
    if (org.apache.flex.utils.Language.is(value, String)) {
      this._style = org.apache.flex.core.ValuesManager.valuesImpl.parseStyles(value);
    }
    else
      this._style = value;
    if (!isNaN(this._y))
      this._style.top = this._y;
    if (!isNaN(this._x))
      this._style.left = this._x;
    this.dispatchEvent(new org.apache.flex.events.Event("stylesChanged"));
  }
}},
/** @export */
className: {
get: /** @this {org.apache.flex.core.UIBase} */ function() {
  return this._className;
},
set: /** @this {org.apache.flex.core.UIBase} */ function(value) {
  if (this._className != value) {
    this.element.className = this.typeNames ? value + ' ' + this.typeNames : value;
    this._className = value;
    this.dispatchEvent(new org.apache.flex.events.Event("classNameChanged"));
  }
}},
/** @export */
numElements: {
get: /** @this {org.apache.flex.core.UIBase} */ function() {
  
  var /** @type {Array} */ children = this.internalChildren();
  return children.length;
}},
/** @export */
measurementBead: {
get: /** @this {org.apache.flex.core.UIBase} */ function() {
  var /** @type {org.apache.flex.core.IMeasurementBead} */ measurementBead = org.apache.flex.utils.Language.as(this.getBeadByType(org.apache.flex.core.IMeasurementBead), org.apache.flex.core.IMeasurementBead);
  if (measurementBead == null) {
    this.addBead(measurementBead = org.apache.flex.utils.Language.as(new (org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "iMeasurementBead"))(), org.apache.flex.core.IMeasurementBead));
  }
  return measurementBead;
}},
/** @export */
topMostEventDispatcher: {
get: /** @this {org.apache.flex.core.UIBase} */ function() {
  
  var /** @type {org.apache.flex.core.WrappedHTMLElement} */ e = document.body;
  return e.flexjs_wrapper;
}},
/** @export */
positioner: {
get: /** @this {org.apache.flex.core.UIBase} */ function() {
  return this._positioner;
},
set: /** @this {org.apache.flex.core.UIBase} */ function(value) {
  this._positioner = value;
}},
/** @export */
alpha: {
get: /** @this {org.apache.flex.core.UIBase} */ function() {
  var /** @type {string} */ stralpha = this.positioner.style.opacity;
  var /** @type {number} */ alpha = parseFloat(stralpha);
  return alpha;
},
set: /** @this {org.apache.flex.core.UIBase} */ function(value) {
  this.positioner.style.opacity = value;
}},
/** @export */
parent: {
get: /** @this {org.apache.flex.core.UIBase} */ function() {
  var /** @type {org.apache.flex.core.WrappedHTMLElement} */ p = this.positioner.parentNode;
  var /** @type {org.apache.flex.core.IUIBase} */ wrapper = p ? p.flexjs_wrapper : null;
  return wrapper;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.core.UIBase.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'UIBase', qName: 'org.apache.flex.core.UIBase'}], interfaces: [org.apache.flex.core.IStrandWithModel, org.apache.flex.events.IEventDispatcher, org.apache.flex.core.IParentIUIBase, org.apache.flex.core.IStyleableObject, org.apache.flex.core.ILayoutChild, org.apache.flex.core.IFlexJSElement] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.core.UIBase', org.apache.flex.core.UIBase);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.core.UIBase.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'typeNames': { type: 'String'},
        'beads': { type: 'Array'}
      };
    },
    accessors: function () {
      return {
        'explicitWidth': { type: 'Number', declaredBy: 'org.apache.flex.core.UIBase'},
        'explicitHeight': { type: 'Number', declaredBy: 'org.apache.flex.core.UIBase'},
        'percentWidth': { type: 'Number', declaredBy: 'org.apache.flex.core.UIBase'},
        'percentHeight': { type: 'Number', declaredBy: 'org.apache.flex.core.UIBase'},
        'width': { type: 'Number', declaredBy: 'org.apache.flex.core.UIBase'},
        'height': { type: 'Number', declaredBy: 'org.apache.flex.core.UIBase'},
        'x': { type: 'Number', declaredBy: 'org.apache.flex.core.UIBase'},
        'y': { type: 'Number', declaredBy: 'org.apache.flex.core.UIBase'},
        'visible': { type: 'Boolean', declaredBy: 'org.apache.flex.core.UIBase'},
        'view': { type: 'IBeadView', declaredBy: 'org.apache.flex.core.UIBase'},
        'id': { type: 'String', declaredBy: 'org.apache.flex.core.UIBase'},
        'style': { type: 'Object', declaredBy: 'org.apache.flex.core.UIBase'},
        'className': { type: 'String', declaredBy: 'org.apache.flex.core.UIBase'},
        'numElements': { type: 'int', declaredBy: 'org.apache.flex.core.UIBase'},
        'measurementBead': { type: 'IMeasurementBead', declaredBy: 'org.apache.flex.core.UIBase'},
        'topMostEventDispatcher': { type: 'IEventDispatcher', declaredBy: 'org.apache.flex.core.UIBase'},
        'positioner': { type: 'WrappedHTMLElement', declaredBy: 'org.apache.flex.core.UIBase'},
        'alpha': { type: 'Number', declaredBy: 'org.apache.flex.core.UIBase'},
        'parent': { type: 'IUIBase', declaredBy: 'org.apache.flex.core.UIBase'}
      };
    },
    methods: function () {
      return {
        'UIBase': { type: '', declaredBy: 'org.apache.flex.core.UIBase'},
        'setHeight': { type: 'void', declaredBy: 'org.apache.flex.core.UIBase'},
        'setWidth': { type: 'void', declaredBy: 'org.apache.flex.core.UIBase'},
        'setWidthAndHeight': { type: 'void', declaredBy: 'org.apache.flex.core.UIBase'},
        'isWidthSizedToContent': { type: 'Boolean', declaredBy: 'org.apache.flex.core.UIBase'},
        'isHeightSizedToContent': { type: 'Boolean', declaredBy: 'org.apache.flex.core.UIBase'},
        'setX': { type: 'void', declaredBy: 'org.apache.flex.core.UIBase'},
        'setY': { type: 'void', declaredBy: 'org.apache.flex.core.UIBase'},
        'setDisplayStyleForLayout': { type: 'void', declaredBy: 'org.apache.flex.core.UIBase'},
        'internalChildren': { type: 'Array', declaredBy: 'org.apache.flex.core.UIBase'},
        'addBead': { type: 'void', declaredBy: 'org.apache.flex.core.UIBase'},
        'addElement': { type: 'void', declaredBy: 'org.apache.flex.core.UIBase'},
        'addElementAt': { type: 'void', declaredBy: 'org.apache.flex.core.UIBase'},
        'getElementAt': { type: 'Object', declaredBy: 'org.apache.flex.core.UIBase'},
        'getElementIndex': { type: 'int', declaredBy: 'org.apache.flex.core.UIBase'},
        'removeElement': { type: 'void', declaredBy: 'org.apache.flex.core.UIBase'},
        'addedToParent': { type: 'void', declaredBy: 'org.apache.flex.core.UIBase'}
      };
    },
    metadata: function () { return [ ]; }
  };
};