/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/core/FilledRectangle.as
 * org.apache.flex.core.FilledRectangle
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.core.FilledRectangle');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 */
org.apache.flex.core.FilledRectangle = function() {
  org.apache.flex.core.FilledRectangle.base(this, 'constructor');
  
};
goog.inherits(org.apache.flex.core.FilledRectangle, org.apache.flex.core.UIBase);


/**
 * @private
 * @type {number}
 */
org.apache.flex.core.FilledRectangle.prototype._fillColor = 0x000000;


/**
 *  @asprivate 
 * @export
 * @override
 */
org.apache.flex.core.FilledRectangle.prototype.addedToParent = function() {
  org.apache.flex.core.FilledRectangle.base(this, 'addedToParent');
  this.drawRect(0, 0, this.width, this.height);
};


/**
 *  Draw the rectangle.
 *  @asparam x The x position of the top-left corner of the rectangle.
 *  @asparam y The y position of the top-left corner.
 *  @asparam width The width of the rectangle.
 *  @asparam height The height of the rectangle.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 */
org.apache.flex.core.FilledRectangle.prototype.drawRect = function(x, y, width, height) {
  
  this.element.style.position = 'absolute';
  this.element.style.backgroundColor = '#' + this._fillColor.toString(16);
  if (!isNaN(x))
    this.x = x;
  if (!isNaN(y))
    this.y = y;
  if (!isNaN(width))
    this.width = width;
  if (!isNaN(height))
    this.height = height;
};


Object.defineProperties(org.apache.flex.core.FilledRectangle.prototype, /** @lends {org.apache.flex.core.FilledRectangle.prototype} */ {
/** @export */
fillColor: {
get: /** @this {org.apache.flex.core.FilledRectangle} */ function() {
  return this._fillColor;
},
set: /** @this {org.apache.flex.core.FilledRectangle} */ function(value) {
  this._fillColor = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.core.FilledRectangle.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'FilledRectangle', qName: 'org.apache.flex.core.FilledRectangle'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.core.FilledRectangle', org.apache.flex.core.FilledRectangle);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.core.FilledRectangle.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'fillColor': { type: 'uint', declaredBy: 'org.apache.flex.core.FilledRectangle'}
      };
    },
    methods: function () {
      return {
        'FilledRectangle': { type: '', declaredBy: 'org.apache.flex.core.FilledRectangle'},
        'addedToParent': { type: 'void', declaredBy: 'org.apache.flex.core.FilledRectangle'},
        'drawRect': { type: 'void', declaredBy: 'org.apache.flex.core.FilledRectangle'}
      };
    }
  };
};