/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/collections/converters/JSONItemConverter.as
 * org.apache.flex.collections.converters.JSONItemConverter
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.collections.converters.JSONItemConverter');

goog.require('org.apache.flex.collections.converters.IItemConverter');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @implements {org.apache.flex.collections.converters.IItemConverter}
 */
org.apache.flex.collections.converters.JSONItemConverter = function() {
};


/**
 * @export
 * @param {string} data
 * @return {Object}
 */
org.apache.flex.collections.converters.JSONItemConverter.prototype.convertItem = function(data) {
  var /** @type {number} */ c = data.indexOf("{");
  if (c > 0)
    data = data.substring(c);
  if (data.indexOf("}") == -1)
    data += "}";
  return JSON.parse(data);
};


/**
 *  Get a property from an object.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 * @param {Object} obj
 * @param {string} propName
 * @return {*}
 */
org.apache.flex.collections.converters.JSONItemConverter.prototype.getProperty = function(obj, propName) {
  if (propName === 'this')
    return obj;
  return obj[propName];
};


/**
 *  Set a property on an object.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @protected
 * @param {Object} obj
 * @param {string} propName
 * @param {*} value
 */
org.apache.flex.collections.converters.JSONItemConverter.prototype.setProperty = function(obj, propName, value) {
  obj[propName] = value;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.collections.converters.JSONItemConverter.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'JSONItemConverter', qName: 'org.apache.flex.collections.converters.JSONItemConverter'}], interfaces: [org.apache.flex.collections.converters.IItemConverter] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.collections.converters.JSONItemConverter', org.apache.flex.collections.converters.JSONItemConverter);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.collections.converters.JSONItemConverter.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'convertItem': { type: 'Object', declaredBy: 'org.apache.flex.collections.converters.JSONItemConverter'}
      };
    }
  };
};