/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/collections/FlattenedList.as
 * org.apache.flex.collections.FlattenedList
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.collections.FlattenedList');

goog.require('org.apache.flex.collections.ArrayList');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.collections.ArrayList}
 * @param {org.apache.flex.collections.HierarchicalData} hdata
 */
org.apache.flex.collections.FlattenedList = function(hdata) {
  org.apache.flex.collections.FlattenedList.base(this, 'constructor');
  this.hdata = hdata;
  this.openNodes = [];
  this.reset();
};
goog.inherits(org.apache.flex.collections.FlattenedList, org.apache.flex.collections.ArrayList);


/**
 * @export
 * @type {org.apache.flex.collections.HierarchicalData}
 */
org.apache.flex.collections.FlattenedList.prototype.hdata;


/**
 * @export
 * @type {Array}
 */
org.apache.flex.collections.FlattenedList.prototype.openNodes;


/**
 * Resets the list so that only the top root node is open.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 */
org.apache.flex.collections.FlattenedList.prototype.reset = function() {
  var /** @type {Array} */ arr = [];
  this.addChildren(this.hdata.getRoot(), arr);
  this.source = arr;
};


/**
 * @asprivate
 * @protected
 * @param {Object} node
 * @param {Array} arr
 */
org.apache.flex.collections.FlattenedList.prototype.addChildren = function(node, arr) {
  var /** @type {Array} */ children = org.apache.flex.utils.Language.as(this.hdata.getChildren(node), Array);
  var /** @type {number} */ n = children.length;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    arr.push(children[i]);
    if (this.isOpen(children[i])) {
      this.addChildren(children[i], arr);
    }
  }
};


/**
 * Returns true if the node has children nodes.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} node
 * @return {boolean}
 */
org.apache.flex.collections.FlattenedList.prototype.hasChildren = function(node) {
  return this.hdata.hasChildren(node);
};


/**
 * Returns true if the node is currently open.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} node
 * @return {boolean}
 */
org.apache.flex.collections.FlattenedList.prototype.isOpen = function(node) {
  return this.openNodes.indexOf(node) != -1;
};


/**
 * Opens the given node. The array data now contains more elements.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} node
 */
org.apache.flex.collections.FlattenedList.prototype.openNode = function(node) {
  if (this.hdata.hasChildren(node)) {
    this.openNodes.push(node);
    var /** @type {Array} */ arr = [];
    this.addChildren(node, arr);
    var /** @type {number} */ i = this.getItemIndex(node);
    while (arr.length) {
      this.addItemAt(arr.shift(), ++i);
    }
  }
};


/**
 * Closes the given node. The array data now contains fewer elements.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} node
 */
org.apache.flex.collections.FlattenedList.prototype.closeNode = function(node) {
  var /** @type {number} */ i = this.openNodes.indexOf(node);
  if (i != -1) {
    if (this.hdata.hasChildren(node)) {
      var /** @type {Array} */ children = org.apache.flex.utils.Language.as(this.hdata.getChildren(node), Array);
      var /** @type {number} */ n = children.length;
      for (var /** @type {number} */ j = 0; j < n; j++) {
        this.closeNode(children[j]);
      }
    }
    this.openNodes.splice(i, 1);
    var /** @type {Array} */ arr = [];
    this.addChildren(node, arr);
    i = this.getItemIndex(node) + 1;
    while (arr.length) {
      this.removeItemAt(i);
      arr.shift();
    }
  }
};


/**
 * Returns the depth of the node with the root being zero.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} node
 * @return {number}
 */
org.apache.flex.collections.FlattenedList.prototype.getDepth = function(node) {
  var /** @type {number} */ depth = this.godeep(node, this.hdata.getRoot(), 0);
  return depth;
};


/**
 * @asprivate
 * @private
 * @param {Object} seeking
 * @param {Object} node
 * @param {number} depth
 * @return {number}
 */
org.apache.flex.collections.FlattenedList.prototype.godeep = function(seeking, node, depth) {
  if (seeking == node)
    return depth;
  if (this.hdata.hasChildren(node)) {
    var /** @type {Array} */ children = org.apache.flex.utils.Language.as(this.hdata.getChildren(node), Array);
    for (var /** @type {number} */ i = 0; i < children.length; i++) {
      var /** @type {number} */ newDepth = this.godeep(seeking, children[i], depth + 1);
      if (newDepth > 0)
        return newDepth;
    }
  }
  return -1;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.collections.FlattenedList.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'FlattenedList', qName: 'org.apache.flex.collections.FlattenedList'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.collections.FlattenedList', org.apache.flex.collections.FlattenedList);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.collections.FlattenedList.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'hdata': { type: 'HierarchicalData'},
        'openNodes': { type: 'Array'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'FlattenedList': { type: '', declaredBy: 'org.apache.flex.collections.FlattenedList'},
        'reset': { type: 'void', declaredBy: 'org.apache.flex.collections.FlattenedList'},
        'hasChildren': { type: 'Boolean', declaredBy: 'org.apache.flex.collections.FlattenedList'},
        'isOpen': { type: 'Boolean', declaredBy: 'org.apache.flex.collections.FlattenedList'},
        'openNode': { type: 'void', declaredBy: 'org.apache.flex.collections.FlattenedList'},
        'closeNode': { type: 'void', declaredBy: 'org.apache.flex.collections.FlattenedList'},
        'getDepth': { type: 'int', declaredBy: 'org.apache.flex.collections.FlattenedList'}
      };
    }
  };
};