/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/optimized/SVGChartDataGroup.as
 * org.apache.flex.charts.optimized.SVGChartDataGroup
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.optimized.SVGChartDataGroup');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.svg.CompoundGraphic');
goog.require('org.apache.flex.charts.core.IChartDataGroup');
goog.require('org.apache.flex.charts.core.IChartItemRenderer');
goog.require('org.apache.flex.core.IContentView');
goog.require('org.apache.flex.core.IItemRenderer');
goog.require('org.apache.flex.core.IItemRendererParent');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.svg.CompoundGraphic}
 * @implements {org.apache.flex.core.IItemRendererParent}
 * @implements {org.apache.flex.core.IContentView}
 * @implements {org.apache.flex.charts.core.IChartDataGroup}
 */
org.apache.flex.charts.optimized.SVGChartDataGroup = function() {
  org.apache.flex.charts.optimized.SVGChartDataGroup.base(this, 'constructor');
  this._children = new Array();
  this.addEventListener("widthChanged", org.apache.flex.utils.Language.closure(this.resizeContainer, this, 'resizeContainer'));
  this.addEventListener("heightChanged", org.apache.flex.utils.Language.closure(this.resizeContainer, this, 'resizeContainer'));
};
goog.inherits(org.apache.flex.charts.optimized.SVGChartDataGroup, org.apache.flex.svg.CompoundGraphic);


/**
 * @private
 * @type {Array}
 */
org.apache.flex.charts.optimized.SVGChartDataGroup.prototype._children;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.charts.optimized.SVGChartDataGroup.prototype._strand;


/**
 *  @copy org.apache.flex.core.IItemRendererParent#getItemRendererForIndex()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} index
 * @return {org.apache.flex.core.IItemRenderer}
 */
org.apache.flex.charts.optimized.SVGChartDataGroup.prototype.getItemRendererForIndex = function(index) {
  if (index < 0 || index >= this._children.length)
    return null;
  return org.apache.flex.utils.Language.as(this._children[index], org.apache.flex.core.IItemRenderer);
};


/**
 *  Returns the itemRenderer that matches both the series and child index. A null return is
 *  valid since some charts have optional itemRenderers for their series.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {org.apache.flex.charts.core.IChartSeries} series
 * @param {number} index
 * @return {org.apache.flex.charts.core.IChartItemRenderer}
 */
org.apache.flex.charts.optimized.SVGChartDataGroup.prototype.getItemRendererForSeriesAtIndex = function(series, index) {
  var /** @type {number} */ n = this._children.length;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {org.apache.flex.charts.core.IChartItemRenderer} */ child = org.apache.flex.utils.Language.as(this._children[i], org.apache.flex.charts.core.IChartItemRenderer);
    if (child && child.series == series) {
      if (index == 0)
        return child;
      --index;
    }
  }
  return null;
};


/**
 *  @copy org.apache.flex.core.IItemRendererParent#removeAllElements()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @override
 */
org.apache.flex.charts.optimized.SVGChartDataGroup.prototype.removeAllElements = function() {
  org.apache.flex.charts.optimized.SVGChartDataGroup.base(this, 'removeAllElements');
  this._children = new Array();
};


/**
 *  Overrides the addElement function to set the element into an internal
 *  list.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @override
 */
org.apache.flex.charts.optimized.SVGChartDataGroup.prototype.addElement = function(value, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  this._children.push(value);
  var /** @type {org.apache.flex.core.UIBase} */ base = org.apache.flex.utils.Language.as(value, org.apache.flex.core.UIBase);
  base.addedToParent();
  org.apache.flex.charts.optimized.SVGChartDataGroup.base(this, 'addElement', value, dispatchEvent);
};


/**
 *  Overrides the addElementAt function to set the element into an internal
 *  list.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @override
 */
org.apache.flex.charts.optimized.SVGChartDataGroup.prototype.addElementAt = function(value, index, dispatchEvent) {
  dispatchEvent = typeof dispatchEvent !== 'undefined' ? dispatchEvent : true;
  if (index >= this._children.length)
    this._children.push(value);
  else
    this._children.splice(index, 0, value);
  var /** @type {org.apache.flex.core.UIBase} */ base = org.apache.flex.utils.Language.as(value, org.apache.flex.core.UIBase);
  base.addedToParent();
  org.apache.flex.charts.optimized.SVGChartDataGroup.base(this, 'addElementAt', value, index, dispatchEvent);
};


/**
 *  @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.charts.optimized.SVGChartDataGroup.prototype.resizeContainer = function(event) {
};


/**
 * @export
 * @param {org.apache.flex.geom.Point} point
 * @return {org.apache.flex.charts.core.IChartItemRenderer}
 */
org.apache.flex.charts.optimized.SVGChartDataGroup.prototype.getItemRendererUnderPoint = function(point) {
  return null;
};


/**
 * @export
 */
org.apache.flex.charts.optimized.SVGChartDataGroup.prototype.updateAllItemRenderers = function() {
};


Object.defineProperties(org.apache.flex.charts.optimized.SVGChartDataGroup.prototype, /** @lends {org.apache.flex.charts.optimized.SVGChartDataGroup.prototype} */ {
/** @export */
strand: {
get: /** @this {org.apache.flex.charts.optimized.SVGChartDataGroup} */ function() {
  return this._strand;
},
set: /** @this {org.apache.flex.charts.optimized.SVGChartDataGroup} */ function(value) {
  this._strand = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.optimized.SVGChartDataGroup.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'SVGChartDataGroup', qName: 'org.apache.flex.charts.optimized.SVGChartDataGroup'}], interfaces: [org.apache.flex.core.IItemRendererParent, org.apache.flex.core.IContentView, org.apache.flex.charts.core.IChartDataGroup] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.optimized.SVGChartDataGroup', org.apache.flex.charts.optimized.SVGChartDataGroup);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.optimized.SVGChartDataGroup.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.charts.optimized.SVGChartDataGroup'}
      };
    },
    methods: function () {
      return {
        'SVGChartDataGroup': { type: '', declaredBy: 'org.apache.flex.charts.optimized.SVGChartDataGroup'},
        'getItemRendererForIndex': { type: 'IItemRenderer', declaredBy: 'org.apache.flex.charts.optimized.SVGChartDataGroup'},
        'getItemRendererForSeriesAtIndex': { type: 'IChartItemRenderer', declaredBy: 'org.apache.flex.charts.optimized.SVGChartDataGroup'},
        'removeAllElements': { type: 'void', declaredBy: 'org.apache.flex.charts.optimized.SVGChartDataGroup'},
        'addElement': { type: 'void', declaredBy: 'org.apache.flex.charts.optimized.SVGChartDataGroup'},
        'addElementAt': { type: 'void', declaredBy: 'org.apache.flex.charts.optimized.SVGChartDataGroup'},
        'getItemRendererUnderPoint': { type: 'IChartItemRenderer', declaredBy: 'org.apache.flex.charts.optimized.SVGChartDataGroup'},
        'updateAllItemRenderers': { type: 'void', declaredBy: 'org.apache.flex.charts.optimized.SVGChartDataGroup'}
      };
    }
  };
};