/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/beads/layouts/StackedColumnChartLayout.as
 * org.apache.flex.charts.beads.layouts.StackedColumnChartLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.beads.layouts.StackedColumnChartLayout');

goog.require('org.apache.flex.charts.beads.layouts.ChartBaseLayout');
goog.require('org.apache.flex.charts.supportClasses.ColumnSeries');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.charts.core.ICartesianChartLayout');
goog.require('org.apache.flex.core.IBeadLayout');
goog.require('org.apache.flex.core.ILayoutHost');
goog.require('org.apache.flex.core.IParentIUIBase');
goog.require('org.apache.flex.core.ISelectionModel');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.charts.beads.layouts.ChartBaseLayout}
 * @implements {org.apache.flex.core.IBeadLayout}
 * @implements {org.apache.flex.charts.core.ICartesianChartLayout}
 */
org.apache.flex.charts.beads.layouts.StackedColumnChartLayout = function() {
  org.apache.flex.charts.beads.layouts.StackedColumnChartLayout.base(this, 'constructor');
};
goog.inherits(org.apache.flex.charts.beads.layouts.StackedColumnChartLayout, org.apache.flex.charts.beads.layouts.ChartBaseLayout);


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.beads.layouts.StackedColumnChartLayout.prototype._gap = 20;


/**
 * @asprivate
 * @protected
 * @override
 */
org.apache.flex.charts.beads.layouts.StackedColumnChartLayout.prototype.performLayout = function() {
  var /** @type {org.apache.flex.core.ISelectionModel} */ selectionModel = org.apache.flex.utils.Language.as(this.chart.getBeadByType(org.apache.flex.core.ISelectionModel), org.apache.flex.core.ISelectionModel);
  var /** @type {Array} */ dp = org.apache.flex.utils.Language.as(selectionModel.dataProvider, Array);
  if (!dp)
    return;
  var /** @type {org.apache.flex.core.ILayoutHost} */ layoutParent = org.apache.flex.utils.Language.as(this.strand.getBeadByType(org.apache.flex.core.ILayoutHost), org.apache.flex.core.ILayoutHost);
  var /** @type {org.apache.flex.core.IParentIUIBase} */ contentView = org.apache.flex.utils.Language.as(layoutParent.contentView, org.apache.flex.core.IParentIUIBase);
  var /** @type {number} */ n = dp.length;
  var /** @type {number} */ useWidth = contentView.width;
  var /** @type {number} */ useHeight = contentView.height;
  var /** @type {number} */ itemWidth = (useWidth - this.gap * (dp.length - 1)) / dp.length;
  var /** @type {number} */ seriesWidth = itemWidth;
  var /** @type {number} */ xpos = 0;
  var /** @type {number} */ ypos = 0;
  var /** @type {number} */ maxYValue = 0;
  var /** @type {number} */ minYValue = 0;
  var /** @type {boolean} */ determineScale = true;
  var /** @type {Array} */ barValues = [];
  var /** @type {number} */ scaleFactor = 1;
  if (this.verticalAxisBead != null && !isNaN(this.verticalAxisBead.maximum)) {
    maxYValue = this.verticalAxisBead.maximum;
    determineScale = false;
  }
  if (this.verticalAxisBead != null && !isNaN(this.verticalAxisBead.minimum)) {
    minYValue = this.verticalAxisBead.minimum;
  }
  for (var /** @type {number} */ i = 0; i < n; i++) {
    barValues.push({totalValue:0});
    var /** @type {Object} */ data = dp[i];
    for (var /** @type {number} */ s = 0; s < this.chart.series.length; s++) {
      var /** @type {org.apache.flex.charts.supportClasses.ColumnSeries} */ bcs = org.apache.flex.utils.Language.as(this.chart.series[s], org.apache.flex.charts.supportClasses.ColumnSeries);
      var /** @type {string} */ field = bcs.yField;
      var /** @type {number} */ yValue = Number(data[field]);
      barValues[i].totalValue += yValue;
    }
    if (determineScale) {
      maxYValue = Math.max(maxYValue, barValues[i].totalValue);
    }
  }
  scaleFactor = useHeight / (maxYValue - minYValue);
  for (i = 0; i < n; i++) {
    data = dp[i];
    ypos = useHeight;
    for (s = 0; s < this.chart.series.length; s++) {
      bcs = org.apache.flex.utils.Language.as(this.chart.series[s], org.apache.flex.charts.supportClasses.ColumnSeries);
      var /** @type {org.apache.flex.charts.core.IChartItemRenderer} */ child = this.chartDataGroup.getItemRendererForSeriesAtIndex(bcs, i);
      yValue = Number(data[field]) - minYValue;
      yValue = yValue * scaleFactor;
      child.x = xpos;
      child.width = itemWidth;
      child.y = ypos - Math.ceil(yValue);
      child.height = Math.floor(yValue);
      ypos = child.y;
    }
    xpos += this.gap + itemWidth;
  }
  org.apache.flex.utils.Language.as(this.chart, org.apache.flex.events.IEventDispatcher, true).dispatchEvent(new org.apache.flex.events.Event("layoutComplete"));
};


Object.defineProperties(org.apache.flex.charts.beads.layouts.StackedColumnChartLayout.prototype, /** @lends {org.apache.flex.charts.beads.layouts.StackedColumnChartLayout.prototype} */ {
/** @export */
gap: {
get: /** @this {org.apache.flex.charts.beads.layouts.StackedColumnChartLayout} */ function() {
  return this._gap;
},
set: /** @this {org.apache.flex.charts.beads.layouts.StackedColumnChartLayout} */ function(value) {
  this._gap = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.beads.layouts.StackedColumnChartLayout.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'StackedColumnChartLayout', qName: 'org.apache.flex.charts.beads.layouts.StackedColumnChartLayout'}], interfaces: [org.apache.flex.core.IBeadLayout, org.apache.flex.charts.core.ICartesianChartLayout] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.beads.layouts.StackedColumnChartLayout', org.apache.flex.charts.beads.layouts.StackedColumnChartLayout);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.beads.layouts.StackedColumnChartLayout.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'gap': { type: 'Number', declaredBy: 'org.apache.flex.charts.beads.layouts.StackedColumnChartLayout'}
      };
    },
    methods: function () {
      return {
        'StackedColumnChartLayout': { type: '', declaredBy: 'org.apache.flex.charts.beads.layouts.StackedColumnChartLayout'}
      };
    }
  };
};