/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/beads/HorizontalCategoryAxisBead.as
 * org.apache.flex.charts.beads.HorizontalCategoryAxisBead
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.beads.HorizontalCategoryAxisBead');

goog.require('org.apache.flex.charts.beads.AxisBaseBead');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.html.beads.models.ArraySelectionModel');
goog.require('org.apache.flex.charts.core.IHorizontalAxisBead');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.ISelectionModel');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.charts.beads.AxisBaseBead}
 * @implements {org.apache.flex.core.IBead}
 * @implements {org.apache.flex.charts.core.IHorizontalAxisBead}
 */
org.apache.flex.charts.beads.HorizontalCategoryAxisBead = function() {
  org.apache.flex.charts.beads.HorizontalCategoryAxisBead.base(this, 'constructor');
  this.placement = "bottom";
};
goog.inherits(org.apache.flex.charts.beads.HorizontalCategoryAxisBead, org.apache.flex.charts.beads.AxisBaseBead);


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.beads.HorizontalCategoryAxisBead.prototype._axisHeight = 30;


/**
 * @private
 * @type {string}
 */
org.apache.flex.charts.beads.HorizontalCategoryAxisBead.prototype._categoryField;


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.beads.HorizontalCategoryAxisBead.prototype._gap = 20;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.charts.beads.HorizontalCategoryAxisBead.prototype._strand;


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.charts.beads.HorizontalCategoryAxisBead.prototype.handleItemsCreated = function(event) {
  var /** @type {org.apache.flex.html.beads.models.ArraySelectionModel} */ model = org.apache.flex.utils.Language.as(this.strand.getBeadByType(org.apache.flex.core.ISelectionModel), org.apache.flex.html.beads.models.ArraySelectionModel);
  var /** @type {Array} */ items;
  if (org.apache.flex.utils.Language.is(model.dataProvider, Array))
    items = org.apache.flex.utils.Language.as(model.dataProvider, Array);
  else
    return;
  this.clearGraphics();
  var /** @type {number} */ xpos = 0;
  var /** @type {number} */ useWidth = org.apache.flex.utils.Language.as(this.axisGroup, org.apache.flex.core.UIBase, true).width;
  var /** @type {number} */ labelY = 7;
  var /** @type {number} */ itemWidth = (useWidth - this.gap * (items.length - 1)) / items.length;
  for (var /** @type {number} */ i = 0; i < items.length; i++) {
    this.addTickLabel(items[i][this.categoryField], xpos, labelY, itemWidth, 0);
    this.addTickMark(xpos + itemWidth / 2, 0, 0, 5);
    xpos += itemWidth + this.gap;
  }
  this.drawAxisPath(0, 0, useWidth, 1);
  this.drawTickPath(0, 1);
};


Object.defineProperties(org.apache.flex.charts.beads.HorizontalCategoryAxisBead.prototype, /** @lends {org.apache.flex.charts.beads.HorizontalCategoryAxisBead.prototype} */ {
/** @export */
axisHeight: {
get: /** @this {org.apache.flex.charts.beads.HorizontalCategoryAxisBead} */ function() {
  return this._axisHeight;
},
set: /** @this {org.apache.flex.charts.beads.HorizontalCategoryAxisBead} */ function(value) {
  this._axisHeight = value;
}},
/** @export */
categoryField: {
get: /** @this {org.apache.flex.charts.beads.HorizontalCategoryAxisBead} */ function() {
  return this._categoryField;
},
set: /** @this {org.apache.flex.charts.beads.HorizontalCategoryAxisBead} */ function(value) {
  this._categoryField = value;
}},
/** @export */
gap: {
get: /** @this {org.apache.flex.charts.beads.HorizontalCategoryAxisBead} */ function() {
  return this._gap;
},
set: /** @this {org.apache.flex.charts.beads.HorizontalCategoryAxisBead} */ function(value) {
  this._gap = value;
}},
/** @export */
maximum: {
get: /** @this {org.apache.flex.charts.beads.HorizontalCategoryAxisBead} */ function() {
  return Number.NaN;
}},
/** @export */
minimum: {
get: /** @this {org.apache.flex.charts.beads.HorizontalCategoryAxisBead} */ function() {
  return 0;
}},
/** @export */
strand: {
get: /** @this {org.apache.flex.charts.beads.HorizontalCategoryAxisBead} */ function() {
  return this._strand;
},
set: /** @this {org.apache.flex.charts.beads.HorizontalCategoryAxisBead} */ function(value) {
  this._strand = value;
  org.apache.flex.utils.Language.superSetter(org.apache.flex.charts.beads.HorizontalCategoryAxisBead, this, 'strand', value);
  org.apache.flex.utils.Language.as(value, org.apache.flex.events.IEventDispatcher, true).addEventListener("layoutComplete", org.apache.flex.utils.Language.closure(this.handleItemsCreated, this, 'handleItemsCreated'));
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.beads.HorizontalCategoryAxisBead.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'HorizontalCategoryAxisBead', qName: 'org.apache.flex.charts.beads.HorizontalCategoryAxisBead'}], interfaces: [org.apache.flex.core.IBead, org.apache.flex.charts.core.IHorizontalAxisBead] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.beads.HorizontalCategoryAxisBead', org.apache.flex.charts.beads.HorizontalCategoryAxisBead);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.beads.HorizontalCategoryAxisBead.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'axisHeight': { type: 'Number', declaredBy: 'org.apache.flex.charts.beads.HorizontalCategoryAxisBead'},
        'categoryField': { type: 'String', declaredBy: 'org.apache.flex.charts.beads.HorizontalCategoryAxisBead'},
        'gap': { type: 'Number', declaredBy: 'org.apache.flex.charts.beads.HorizontalCategoryAxisBead'},
        'maximum': { type: 'Number', declaredBy: 'org.apache.flex.charts.beads.HorizontalCategoryAxisBead'},
        'minimum': { type: 'Number', declaredBy: 'org.apache.flex.charts.beads.HorizontalCategoryAxisBead'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.charts.beads.HorizontalCategoryAxisBead'}
      };
    },
    methods: function () {
      return {
        'HorizontalCategoryAxisBead': { type: '', declaredBy: 'org.apache.flex.charts.beads.HorizontalCategoryAxisBead'}
      };
    }
  };
};