/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from google/maps/geometry/poly.as
 * google.maps.geometry.poly
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('google.maps.geometry.poly');



/**
 * @see [google_maps_api_v3_11]
 * @constructor
 */
google.maps.geometry.poly = function() {
};


/**
 * @asparam point [(google.maps.LatLng|null)] 
 * @asparam polygon [(google.maps.Polygon|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {boolean} 
 * @export
 * @param {google.maps.LatLng} point
 * @param {google.maps.Polygon} polygon
 * @return {boolean}
 */
google.maps.geometry.poly.containsLocation = function(point, polygon) {
  return null;
};


/**
 * @asparam point [(google.maps.LatLng|null)] 
 * @asparam poly [(google.maps.Polygon|google.maps.Polyline|null)] 
 * @asparam opt_tolerance [(number|undefined)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {boolean} 
 * @export
 * @param {google.maps.LatLng} point
 * @param {Object} poly
 * @param {number=} opt_tolerance
 * @return {boolean}
 */
google.maps.geometry.poly.isLocationOnEdge = function(point, poly, opt_tolerance) {
  opt_tolerance = typeof opt_tolerance !== 'undefined' ? opt_tolerance : 0;
  return null;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
google.maps.geometry.poly.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'poly', qName: 'google.maps.geometry.poly'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('google.maps.geometry.poly', google.maps.geometry.poly);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
google.maps.geometry.poly.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'poly': { type: 'void', declaredBy: 'google.maps.geometry.poly'}
      };
    }
  };
};