/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from QName.as
 * QName
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('QName');

goog.require('Namespace');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @param {*=} qNameOrUri
 * @param {*=} localNameVal
 */
QName = function(qNameOrUri, localNameVal) {
  qNameOrUri = typeof qNameOrUri !== 'undefined' ? qNameOrUri : null;
  localNameVal = typeof localNameVal !== 'undefined' ? localNameVal : null;
  if (org.apache.flex.utils.Language.is(qNameOrUri, QName)) {
    this._uri = org.apache.flex.utils.Language.string(qNameOrUri.uri);
    this._localName = org.apache.flex.utils.Language.string(qNameOrUri.localName);
    this._prefix = org.apache.flex.utils.Language.string(qNameOrUri.prefix);
  } else if (org.apache.flex.utils.Language.is(qNameOrUri, Namespace)) {
    this._uri = org.apache.flex.utils.Language.as(qNameOrUri, Namespace).uri;
    this._prefix = org.apache.flex.utils.Language.as(qNameOrUri, Namespace).prefix;
    if (localNameVal)
      this._localName = localNameVal.toString();
  } else if (localNameVal) {
    this._localName = org.apache.flex.utils.Language.string(localNameVal);
    this._uri = org.apache.flex.utils.Language.string(qNameOrUri);
  } else if (qNameOrUri && qNameOrUri.toString()) {
    this._localName = qNameOrUri.toString();
  }
};


/**
 * @private
 * @type {string}
 */
QName.prototype._uri;


/**
 * @private
 * @type {string}
 */
QName.prototype._localName;


/**
 * @private
 * @type {string}
 */
QName.prototype._prefix;


/**
 * @export
 * @return {string}
 */
QName.prototype.toString = function() {
  var /** @type {string} */ uriVal = this._uri ? this._uri : "*";
  return uriVal + "::" + this._localName;
};


/**
 * @export
 * @param {QName} name
 * @return {boolean}
 */
QName.prototype.equals = function(name) {
  return this.uri == name.uri && this.localName == name.localName;
};


/**
 * @export
 * @param {QName} name
 * @return {boolean}
 */
QName.prototype.matches = function(name) {
  if (this.uri == "*" || name.uri == "*")
    return this.localName == "*" || name.localName == "*" || this.localName == name.localName;
  if (this.localName == "*" || name.localName == "*")
    return this.uri == name.uri;
  return this.uri == name.uri && this.localName == name.localName;
};


/**
 * @private
 * @type {boolean}
 */
QName.prototype._isAttribute;


/**
 * @export
 * @param {Array=} namespaces
 * @return {Namespace}
 */
QName.prototype.getNamespace = function(namespaces) {
  namespaces = typeof namespaces !== 'undefined' ? namespaces : null;
  var /** @type {number} */ i;
  var /** @type {Namespace} */ possibleMatch;
  if (!namespaces)
    namespaces = [];
  for (i = 0; i < namespaces.length; i++) {
    if (namespaces[i].uri == this._uri) {
      possibleMatch = namespaces[i];
      if (namespaces[i].prefix == this._prefix)
        return namespaces[i];
    }
  }
  if (possibleMatch)
    return possibleMatch;
  if (!this._prefix)
    return new Namespace(this._uri);
  return new Namespace(this._prefix, this._uri);
};


Object.defineProperties(QName.prototype, /** @lends {QName.prototype} */ {
/** @export */
uri: {
get: /** @this {QName} */ function() {
  return this._uri;
},
set: /** @this {QName} */ function(value) {
  this._uri = value;
}},
/** @export */
localName: {
get: /** @this {QName} */ function() {
  return this._localName;
},
set: /** @this {QName} */ function(value) {
  this._localName = value;
}},
/** @export */
prefix: {
get: /** @this {QName} */ function() {
  return this._prefix;
},
set: /** @this {QName} */ function(value) {
  this._prefix = value;
}},
/** @export */
isAttribute: {
get: /** @this {QName} */ function() {
  return this._isAttribute;
},
set: /** @this {QName} */ function(value) {
  this._isAttribute = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
QName.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'QName', qName: 'QName'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('QName', QName);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
QName.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'uri': { type: 'String', declaredBy: 'QName'},
        'localName': { type: 'String', declaredBy: 'QName'},
        'prefix': { type: 'String', declaredBy: 'QName'},
        'isAttribute': { type: 'Boolean', declaredBy: 'QName'}
      };
    },
    methods: function () {
      return {
        'QName': { type: '', declaredBy: 'QName'},
        'toString': { type: 'String', declaredBy: 'QName'},
        'equals': { type: 'Boolean', declaredBy: 'QName'},
        'matches': { type: 'Boolean', declaredBy: 'QName'},
        'getNamespace': { type: 'Namespace', declaredBy: 'QName'}
      };
    }
  };
};