/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from Namespace.as
 * Namespace
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('Namespace');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @param {Object=} prefixOrUri
 * @param {Object=} uriValue
 */
Namespace = function(prefixOrUri, uriValue) {
  prefixOrUri = typeof prefixOrUri !== 'undefined' ? prefixOrUri : null;
  uriValue = typeof uriValue !== 'undefined' ? uriValue : null;
  if (!uriValue && prefixOrUri) {
    var /** @type {Object} */ uriVal = uriValue ? uriValue : prefixOrUri;
    if (org.apache.flex.utils.Language.is(uriVal, Namespace)) {
      this._prefix = org.apache.flex.utils.Language.as(uriVal, Namespace).prefix;
      this._uri = org.apache.flex.utils.Language.as(uriVal, Namespace).uri;
    } else if (this.isQName(uriVal)) {
      this._uri = org.apache.flex.utils.Language.string(uriVal.uri ? uriVal.uri : this._uri);
    } else {
      this._uri = uriVal.toString();
      if (this._uri == "")
        this._prefix = "";
    }
  } else if (uriValue) {
    if (this.isQName(uriValue)) {
      if (uriValue.uri)
        this._uri = org.apache.flex.utils.Language.string(uriValue.uri);
    } else {
      this._uri = uriValue.toString();
    }
    if (!this._uri) {
      if (!prefixOrUri)
        this._prefix = "";
      else
        throw new TypeError("invalid prefix");
    }
    else
      this._prefix = prefixOrUri.toString();
  }
};


/**
 * @private
 * @param {Object} val
 * @return {boolean}
 */
Namespace.prototype.isQName = function(val) {
  if (val == null)
    return false;
  if (val.hasOwnProperty("uri") && val.hasOwnProperty("localName") && val.hasOwnProperty("prefix"))
    return true;
  return false;
};


/**
 * @private
 * @type {string}
 */
Namespace.prototype._uri = "";


/**
 * @private
 * @type {string}
 */
Namespace.prototype._prefix = null;


/**
 * @export
 * @return {string}
 */
Namespace.prototype.toString = function() {
  return this.uri;
};


/**
 * @export
 * @override
 */
Namespace.prototype.valueOf = function() {
  return this;
};


Object.defineProperties(Namespace.prototype, /** @lends {Namespace.prototype} */ {
/** @export */
uri: {
get: /** @this {Namespace} */ function() {
  return this._uri;
},
set: /** @this {Namespace} */ function(value) {
  this._uri = value;
}},
/** @export */
prefix: {
get: /** @this {Namespace} */ function() {
  return this._prefix;
},
set: /** @this {Namespace} */ function(value) {
  this._prefix = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
Namespace.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Namespace', qName: 'Namespace'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('Namespace', Namespace);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
Namespace.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'uri': { type: 'String', declaredBy: 'Namespace'},
        'prefix': { type: 'String', declaredBy: 'Namespace'}
      };
    },
    methods: function () {
      return {
        'Namespace': { type: '', declaredBy: 'Namespace'},
        'toString': { type: 'String', declaredBy: 'Namespace'},
        'valueOf': { type: '*', declaredBy: 'Namespace'}
      };
    }
  };
};