/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.apache.felix.webconsole.internal.AbstractConfigurationPrinter;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.core.BundleContextUtil;
import org.apache.felix.webconsole.internal.core.ServiceReferenceComparator;
import org.apache.felix.webconsole.internal.core.ServicesServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServicesConfigurationPrinter
extends AbstractConfigurationPrinter {
    private static final String TITLE = "Services";
    private static final MessageFormat INFO = new MessageFormat("Service {0} - {1} (pid: {2})");
    private static final MessageFormat FROM = new MessageFormat("  from Bundle {0} - {1} ({2}), version {3}");
    private static final MessageFormat USING = new MessageFormat("  Using Bundle {0} - {1} ({2}), version {3}");
    private static final ServiceReference[] NO_REFS = new ServiceReference[0];

    @Override
    public final String getTitle() {
        return TITLE;
    }

    @Override
    public final void printConfiguration(PrintWriter pw) {
        Object[] data = new Object[4];
        ServiceReference[] refs = this.getServices();
        pw.print("Status: ");
        pw.println(ServicesServlet.getStatusLine(refs));
        for (int i = 0; refs != null && i < refs.length; ++i) {
            try {
                int j;
                Bundle bundle = refs[i].getBundle();
                Bundle[] usingBundles = refs[i].getUsingBundles();
                pw.println();
                pw.println(INFO.format(ServicesConfigurationPrinter.params(refs[i], data)));
                pw.println(FROM.format(ServicesConfigurationPrinter.params(bundle, data)));
                String[] keys = refs[i].getPropertyKeys();
                for (j = 0; keys != null && j < keys.length; ++j) {
                    String key = keys[j];
                    if ("service.id".equals(key) || "objectClass".equals(key) || "service.pid".equals(key)) continue;
                    pw.print("    ");
                    pw.print(key);
                    pw.print(": ");
                    pw.println(ServicesServlet.propertyAsString(refs[i], key));
                }
                for (j = 0; usingBundles != null && j < usingBundles.length; ++j) {
                    pw.println(USING.format(ServicesConfigurationPrinter.params(usingBundles[j], data)));
                }
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static final Object[] params(Bundle bundle, Object[] data) {
        data[0] = String.valueOf(bundle.getBundleId());
        data[1] = Util.getName(bundle, Locale.ENGLISH);
        data[2] = bundle.getSymbolicName();
        data[3] = Util.getHeaderValue(bundle, "Bundle-Version");
        return data;
    }

    private static final Object[] params(ServiceReference ref, Object[] data) {
        data[0] = ServicesServlet.propertyAsString(ref, "service.id");
        data[1] = ServicesServlet.propertyAsString(ref, "objectClass");
        data[2] = ServicesServlet.propertyAsString(ref, "service.pid");
        data[3] = "";
        return data;
    }

    private final ServiceReference[] getServices() {
        ServiceReference[] refs = null;
        try {
            refs = BundleContextUtil.getWorkingBundleContext(this.getBundleContext()).getAllServiceReferences(null, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (refs != null) {
            Arrays.sort(refs, new ServiceReferenceComparator());
        } else {
            refs = NO_REFS;
        }
        return refs;
    }
}

