/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.prefs;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.felix.prefs.BackingStoreManager;
import org.apache.felix.prefs.ChangeSet;
import org.apache.felix.prefs.PreferencesDescription;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferencesImpl
implements Preferences {
    protected final Map<String, String> properties = new HashMap<String, String>();
    protected boolean valid = true;
    protected final PreferencesImpl parent;
    protected final Map<String, PreferencesImpl> children = new HashMap<String, PreferencesImpl>();
    protected final String name;
    protected final PreferencesDescription description;
    protected final BackingStoreManager storeManager;
    protected final ChangeSet changeSet = new ChangeSet();

    public PreferencesImpl(PreferencesDescription d, BackingStoreManager storeManager) {
        this.parent = null;
        this.name = "";
        this.description = d;
        this.storeManager = storeManager;
    }

    public PreferencesImpl(PreferencesImpl p, String name) {
        this.parent = p;
        this.name = name;
        this.description = p.description;
        this.storeManager = p.storeManager;
    }

    public ChangeSet getChangeSet() {
        return this.changeSet;
    }

    public PreferencesDescription getDescription() {
        return this.description;
    }

    public PreferencesImpl getRoot() {
        PreferencesImpl root = this;
        while (root.parent != null) {
            root = root.parent;
        }
        return root;
    }

    public Collection<PreferencesImpl> getChildren() {
        return this.children.values();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public BackingStoreManager getBackingStoreManager() {
        return this.storeManager;
    }

    protected void checkValidity() throws IllegalStateException {
        if (!this.valid) {
            throw new IllegalStateException("The preferences node has been removed.");
        }
    }

    protected void checkKey(String key) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
    }

    protected void checkValue(Object value) throws NullPointerException {
        if (value == null) {
            throw new NullPointerException("Value must not be null.");
        }
    }

    public synchronized boolean isValid() {
        return this.valid;
    }

    @Override
    public synchronized void put(String key, String value) {
        this.checkKey(key);
        this.checkValue(value);
        this.checkValidity();
        this.properties.put(key, value);
        this.changeSet.propertyChanged(key);
    }

    @Override
    public synchronized String get(String key, String def) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.checkValidity();
        String value = this.properties.get(key);
        if (value == null) {
            value = def;
        }
        return value;
    }

    @Override
    public synchronized void remove(String key) {
        this.checkKey(key);
        this.checkValidity();
        this.properties.remove(key);
        this.changeSet.propertyRemoved(key);
    }

    @Override
    public synchronized void clear() throws BackingStoreException {
        this.checkValidity();
        for (String key : this.properties.keySet()) {
            this.changeSet.propertyRemoved(key);
        }
        this.properties.clear();
    }

    @Override
    public void putInt(String key, int value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public int getInt(String key, int def) {
        int result = def;
        String value = this.get(key, null);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void putLong(String key, long value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public long getLong(String key, long def) {
        long result = def;
        String value = this.get(key, null);
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void putBoolean(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public boolean getBoolean(String key, boolean def) {
        boolean result = def;
        String value = this.get(key, null);
        if (value != null) {
            if (value.equalsIgnoreCase("true")) {
                result = true;
            } else if (value.equalsIgnoreCase("false")) {
                result = false;
            }
        }
        return result;
    }

    @Override
    public void putFloat(String key, float value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public float getFloat(String key, float def) {
        float result = def;
        String value = this.get(key, null);
        if (value != null) {
            try {
                result = Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void putDouble(String key, double value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public double getDouble(String key, double def) {
        double result = def;
        String value = this.get(key, null);
        if (value != null) {
            try {
                result = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void putByteArray(String key, byte[] value) {
        this.checkKey(key);
        this.checkValue(value);
        try {
            this.put(key, new String(Base64.encodeBase64(value), "utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    public byte[] getByteArray(String key, byte[] def) {
        byte[] result = def;
        String value = this.get(key, null);
        if (value != null) {
            try {
                boolean valid;
                byte[] bytes = value.getBytes("utf-8");
                boolean bl = valid = bytes.length * 6 % 8 == 0;
                if (valid) {
                    for (int i = 0; i < bytes.length - 1; ++i) {
                        byte b = bytes[i];
                        if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57 || b == 43 || b == 47) continue;
                        valid = false;
                        break;
                    }
                }
                if (valid) {
                    result = Base64.decodeBase64(value.getBytes("utf-8"));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public synchronized String[] keys() throws BackingStoreException {
        if (!this.changeSet.hasChanges) {
            this.storeManager.getStore().update(this);
        }
        Set<String> keys = this.properties.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    public synchronized String[] childrenNames() throws BackingStoreException {
        if (!this.changeSet.hasChanges) {
            this.storeManager.getStore().update(this);
        }
        Set<String> names = this.children.keySet();
        return names.toArray(new String[names.size()]);
    }

    @Override
    public Preferences parent() {
        this.checkValidity();
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Preferences node(String pathName) {
        if (pathName == null) {
            throw new NullPointerException("Path must not be null.");
        }
        PreferencesImpl executingNode = this;
        PreferencesImpl preferencesImpl = this;
        synchronized (preferencesImpl) {
            this.checkValidity();
            if (pathName.length() == 0) {
                return this;
            }
            if (pathName.startsWith("/") && this.parent != null) {
                executingNode = this.getRoot();
            }
            if (pathName.startsWith("/")) {
                pathName = pathName.substring(1);
            }
        }
        return executingNode.getNode(pathName, true, true);
    }

    public PreferencesImpl getOrCreateNode(String pathName) {
        if (pathName == null) {
            throw new NullPointerException("Path must not be null.");
        }
        PreferencesImpl executingNode = this;
        if (pathName.length() == 0) {
            return this;
        }
        if (pathName.startsWith("/") && this.parent != null) {
            executingNode = this.getRoot();
        }
        if (pathName.startsWith("/")) {
            pathName = pathName.substring(1);
        }
        return executingNode.getNode(pathName, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PreferencesImpl getNode(String path, boolean saveNewlyCreatedNode, boolean create) {
        if (path.startsWith("/")) {
            throw new IllegalArgumentException("Path must not contained consecutive slashes");
        }
        if (path.endsWith("/")) {
            throw new IllegalArgumentException("Path must not contained trailing slashes");
        }
        if (path.length() == 0) {
            return this;
        }
        PreferencesImpl preferencesImpl = this;
        synchronized (preferencesImpl) {
            this.checkValidity();
            String subPath = null;
            int pos = path.indexOf(47);
            if (pos != -1) {
                subPath = path.substring(pos + 1);
                path = path.substring(0, pos);
            }
            boolean save = false;
            PreferencesImpl child = this.children.get(path);
            if (child == null) {
                if (!create) {
                    return null;
                }
                child = new PreferencesImpl(this, path);
                this.children.put(path, child);
                this.changeSet.childAdded(path);
                if (saveNewlyCreatedNode) {
                    save = true;
                }
                saveNewlyCreatedNode = false;
            }
            PreferencesImpl result = subPath == null ? child : child.getNode(subPath, saveNewlyCreatedNode, create);
            if (save) {
                try {
                    result.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nodeExists(String pathName) throws BackingStoreException {
        if (pathName == null) {
            throw new NullPointerException("Path must not be null.");
        }
        if (pathName.length() == 0) {
            return this.valid;
        }
        PreferencesImpl node = this;
        PreferencesImpl preferencesImpl = this;
        synchronized (preferencesImpl) {
            this.checkValidity();
            if (pathName.startsWith("/") && this.parent != null) {
                node = this.getRoot();
            }
            if (pathName.startsWith("/")) {
                pathName = pathName.substring(1);
            }
        }
        PreferencesImpl searchNode = node.getNode(pathName, false, false);
        return searchNode != null;
    }

    @Override
    public void removeNode() throws BackingStoreException {
        this.checkValidity();
        this.safelyRemoveNode();
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void safelyRemoveNode() {
        if (this.valid) {
            ArrayList<PreferencesImpl> c = null;
            PreferencesImpl preferencesImpl = this;
            synchronized (preferencesImpl) {
                this.valid = false;
                this.properties.clear();
                c = new ArrayList<PreferencesImpl>(this.children.values());
                this.children.clear();
            }
            for (PreferencesImpl child : c) {
                child.safelyRemoveNode();
            }
        }
    }

    protected synchronized void removeChild(PreferencesImpl child) {
        this.children.remove(child.name());
        this.changeSet.childRemoved(child.name());
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String absolutePath() {
        if (this.parent == null) {
            return "/";
        }
        String parentPath = this.parent.absolutePath();
        if (parentPath.length() == 1) {
            return parentPath + this.name;
        }
        return parentPath + '/' + this.name;
    }

    @Override
    public synchronized void flush() throws BackingStoreException {
        this.checkValidity();
        this.storeManager.getStore().store(this);
        this.changeSet.clear();
    }

    @Override
    public synchronized void sync() throws BackingStoreException {
        this.checkValidity();
        this.storeManager.getStore().update(this);
        this.storeManager.getStore().store(this);
    }

    public void update(PreferencesImpl impl) {
        for (Map.Entry<String, String> entry : impl.properties.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.properties.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, PreferencesImpl> entry : impl.children.entrySet()) {
            String name = entry.getKey().toString();
            PreferencesImpl child = entry.getValue();
            if (!this.children.containsKey(name)) {
                this.node(name);
            }
            this.children.get(name).update(child);
        }
    }

    public void applyChanges(PreferencesImpl prefs) {
        ChangeSet changeSet = prefs.getChangeSet();
        if (changeSet.hasChanges) {
            this.changeSet.importChanges(prefs.changeSet);
            Iterator<String> i = changeSet.removedProperties.iterator();
            while (i.hasNext()) {
                this.properties.remove(i.next());
            }
            for (String key : changeSet.changedProperties) {
                this.properties.put(key, prefs.properties.get(key));
            }
            for (String name : changeSet.removedChildren) {
                this.children.remove(name);
            }
        }
        for (PreferencesImpl current : prefs.getChildren()) {
            PreferencesImpl child = this.getOrCreateNode(current.name());
            child.applyChanges(current);
        }
    }
}

