/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.sslfilter.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.http.sslfilter.internal.LogServiceTracker;
import org.apache.felix.http.sslfilter.internal.SslFilter;
import org.apache.felix.http.sslfilter.internal.SystemLogger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.http.whiteboard.Preprocessor;

public class SslFilterActivator
implements BundleActivator {
    private final SslFilter filter = new SslFilter();
    private volatile ServiceRegistration configReceiver;
    private volatile ServiceRegistration filterReg;
    private LogServiceTracker logTracker;

    public void start(BundleContext context) {
        this.logTracker = new LogServiceTracker(context);
        this.logTracker.open();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", "org.apache.felix.http.sslfilter.SslFilter");
        this.configReceiver = context.registerService(ManagedService.class.getName(), (Object)new ServiceFactory(){

            public Object getService(Bundle bundle, ServiceRegistration registration) {
                return new ManagedService(){

                    public void updated(Dictionary properties) throws ConfigurationException {
                        SslFilterActivator.this.configureFilters(properties);
                    }
                };
            }

            public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            }
        }, props);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)properties).put("service.description", "Apache Felix HTTP SSL Filter");
        ((Dictionary)properties).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=*)");
        ((Dictionary)properties).put("osgi.http.whiteboard.filter.pattern", "/");
        this.filterReg = context.registerService(Preprocessor.class.getName(), (Object)this.filter, properties);
        SystemLogger.log(4, "SSL filter registered...");
    }

    public void stop(BundleContext context) {
        if (this.filterReg != null) {
            this.filterReg.unregister();
            this.filterReg = null;
            SystemLogger.log(4, "SSL filter unregistered...");
        }
        if (this.configReceiver != null) {
            this.configReceiver.unregister();
            this.configReceiver = null;
        }
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
    }

    void configureFilters(Dictionary properties) throws ConfigurationException {
        this.filter.configure(properties);
    }
}

