/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.data.analysis;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.ctakes.relationextractor.data.analysis.Utils;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.util.ViewUriUtil;

public class GoldRelationViewer {
    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        CollectionReader collectionReader = Utils.getCollectionReader(options.getInputDirectory());
        AnalysisEngine annotationConsumer = AnalysisEngineFactory.createEngine(RelationContextPrinter.class, (Object[])new Object[]{"RelationType", options.getRelation(), "PrintContext", options.getPrintContext()});
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{annotationConsumer});
    }

    public static class RelationContextPrinter
    extends JCasAnnotator_ImplBase {
        @ConfigurationParameter(name="RelationType", mandatory=true, description="relation type whose instances will be displayed (e.g. location_of)")
        private String relationType;
        @ConfigurationParameter(name="PrintContext", mandatory=true, description="print relation context")
        private boolean printContext;

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            JCas goldView;
            try {
                goldView = jCas.getView("GoldView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            try {
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            HashMap<List<Annotation>, BinaryTextRelation> relationLookup = new HashMap<List<Annotation>, BinaryTextRelation>();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)goldView, BinaryTextRelation.class)) {
                Annotation arg1 = relation.getArg1().getArgument();
                Annotation arg2 = relation.getArg2().getArgument();
                relationLookup.put(Arrays.asList(arg1, arg2), relation);
            }
            File noteFile = new File(ViewUriUtil.getURI((JCas)jCas).toString());
            String fileName = noteFile.getName();
            for (Sentence sentence : JCasUtil.select((JCas)systemView, Sentence.class)) {
                ArrayList<String> formattedRelationsInSentence = new ArrayList<String>();
                List annotationsInSentence = JCasUtil.selectCovered((JCas)goldView, Annotation.class, (AnnotationFS)sentence);
                for (Annotation annot1 : annotationsInSentence) {
                    for (Annotation annot2 : annotationsInSentence) {
                        String text;
                        BinaryTextRelation relation;
                        if (annot1 == annot2 || (relation = (BinaryTextRelation)relationLookup.get(Arrays.asList(annot1, annot2))) == null || !this.relationType.equals("all") && !relation.getCategory().equals(this.relationType)) continue;
                        if (this.printContext) {
                            text = String.format("%s(%s, %s)", relation.getCategory(), annot1.getCoveredText(), annot2.getCoveredText());
                        } else {
                            String type1 = annot1.getClass().getSimpleName();
                            String type2 = annot2.getClass().getSimpleName();
                            String text1 = annot1.getCoveredText();
                            String text2 = annot2.getCoveredText();
                            text = String.format("%s|%s|%s|%s|%s|%s", fileName, relation.getCategory(), text1, type1, text2, type2);
                        }
                        formattedRelationsInSentence.add(text);
                    }
                }
                if (formattedRelationsInSentence.size() <= 0) continue;
                if (this.printContext) {
                    System.out.println();
                    System.out.println(fileName + ": " + sentence.getCoveredText());
                }
                for (String text : formattedRelationsInSentence) {
                    System.out.println(text);
                }
            }
        }
    }

    static interface Options {
        @Option(longName={"xmi-dir"}, description="path to xmi files containing gold annotations")
        public File getInputDirectory();

        @Option(longName={"relation-type"}, description="determines which relation to view (e.g. location_of)", defaultValue={"all"})
        public String getRelation();

        @Option(longName={"print-context"}, description="output relation context")
        public boolean getPrintContext();
    }
}

