/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae.features;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import org.apache.ctakes.constituency.parser.treekernel.TreeExtractor;
import org.apache.ctakes.constituency.parser.util.AnnotationTreeUtils;
import org.apache.ctakes.constituency.parser.util.TreeUtils;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.TopTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.utils.tree.FragmentUtils;
import org.apache.ctakes.utils.tree.SimpleTree;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;

public class TreeFragmentFeatureExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    static HashSet<SimpleTree> frags = null;

    public TreeFragmentFeatureExtractor() {
        if (frags == null) {
            TreeFragmentFeatureExtractor.initializeFrags();
        }
    }

    private static void initializeFrags() {
        frags = new HashSet();
        try {
            File fragsFile = FileLocator.locateFile((String)"org/apache/ctakes/relationextractor/frags_nolex_args.txt");
            Scanner scanner = new Scanner(fragsFile);
            while (scanner.hasNextLine()) {
                frags.add(FragmentUtils.frag2tree((String)scanner.nextLine().trim()));
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Missing fragment file!");
        }
    }

    @Override
    public List<Feature> extract(JCas jcas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        TopTreebankNode root = AnnotationTreeUtils.getTreeCopy((JCas)jcas, (TopTreebankNode)AnnotationTreeUtils.getAnnotationTree((JCas)jcas, (Annotation)arg1));
        TreebankNode t1 = AnnotationTreeUtils.insertAnnotationNode((JCas)jcas, (TopTreebankNode)root, (Annotation)arg1, (String)"ARG1");
        TreebankNode t2 = AnnotationTreeUtils.insertAnnotationNode((JCas)jcas, (TopTreebankNode)root, (Annotation)arg2, (String)"ARG2");
        SimpleTree tree = null;
        tree = t1.getBegin() <= t2.getBegin() && t1.getEnd() >= t2.getEnd() ? TreeExtractor.getSimpleClone((TreebankNode)t1) : (t2.getBegin() <= t1.getBegin() && t2.getEnd() >= t1.getEnd() ? TreeExtractor.getSimpleClone((TreebankNode)t2) : TreeExtractor.extractPathEnclosedTree((TreebankNode)t1, (TreebankNode)t2, (JCas)jcas));
        for (SimpleTree frag : frags) {
            if (!TreeUtils.containsIgnoreCase((SimpleTree)tree, (SimpleTree)frag)) continue;
            features.add(new Feature((Object)("TK_" + frag.toString())));
        }
        return features;
    }
}

