/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.mallet;

import cc.mallet.classify.Classification;
import cc.mallet.classify.Classifier;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.Labeling;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.encoder.CleartkEncoderException;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.features.NameNumber;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.jar.Classifier_ImplBase;

public abstract class MalletClassifier_ImplBase<OUTCOME_TYPE>
extends Classifier_ImplBase<List<NameNumber>, OUTCOME_TYPE, String> {
    protected Classifier classifier;
    Alphabet alphabet;

    public MalletClassifier_ImplBase(FeaturesEncoder<List<NameNumber>> featuresEncoder, OutcomeEncoder<OUTCOME_TYPE, String> outcomeEncoder, Classifier classifier) {
        super(featuresEncoder, outcomeEncoder);
        this.classifier = classifier;
        this.alphabet = classifier.getAlphabet();
    }

    public OUTCOME_TYPE classify(List<Feature> features) throws CleartkProcessingException {
        Classification classification = this.classifier.classify(this.toInstance(features));
        String returnValue = classification.getLabeling().getBestLabel().toString();
        return (OUTCOME_TYPE)this.outcomeEncoder.decode((Object)returnValue);
    }

    public Map<OUTCOME_TYPE, Double> score(List<Feature> features) throws CleartkProcessingException {
        Classification classification = this.classifier.classify(this.toInstance(features));
        Labeling labeling = classification.getLabeling();
        HashMap returnValues = Maps.newHashMap();
        for (int i = 0; i < labeling.numLocations(); ++i) {
            String label = labeling.getLabelAtRank(i).toString();
            Object outcome = this.outcomeEncoder.decode((Object)label);
            double score = labeling.getValueAtRank(i);
            returnValues.put(outcome, score);
        }
        return returnValues;
    }

    public Instance[] toInstances(List<List<Feature>> features) throws CleartkEncoderException {
        Instance[] instances = new Instance[features.size()];
        for (int i = 0; i < features.size(); ++i) {
            instances[i] = this.toInstance(features.get(i));
        }
        return instances;
    }

    public Instance toInstance(List<Feature> features) throws CleartkEncoderException {
        List nameNumbers = (List)this.featuresEncoder.encodeAll(features);
        Iterator nameNumberIterator = nameNumbers.iterator();
        while (nameNumberIterator.hasNext()) {
            NameNumber nameNumber = (NameNumber)nameNumberIterator.next();
            if (this.alphabet.contains((Object)nameNumber.name)) continue;
            nameNumberIterator.remove();
        }
        Object[] keys = new String[nameNumbers.size()];
        double[] values = new double[nameNumbers.size()];
        for (int i = 0; i < nameNumbers.size(); ++i) {
            NameNumber nameNumber = (NameNumber)nameNumbers.get(i);
            keys[i] = nameNumber.name;
            values[i] = nameNumber.number.doubleValue();
        }
        int[] keyIndices = FeatureVector.getObjectIndices((Object[])keys, (Alphabet)this.alphabet, (boolean)true);
        FeatureVector fv = new FeatureVector(this.alphabet, keyIndices, values);
        Instance instance = new Instance((Object)fv, null, null, null);
        return instance;
    }
}

