/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.feature.syntax;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.FeatureExtractor2;
import org.cleartk.syntax.constituent.type.TreebankNode;
import org.cleartk.syntax.constituent.type.TreebankNodeUtil;

public class SyntacticPathExtractor
implements FeatureExtractor2<TreebankNode, TreebankNode> {
    protected final String UP_SEPARATOR = "::";
    protected final String DOWN_SEPARATOR = ";;";
    protected FeatureExtractor1<TreebankNode> pathMemberExtractor;
    protected String name;
    protected boolean isPartial;

    public SyntacticPathExtractor(FeatureExtractor1<TreebankNode> pathMemberExtractor, boolean partial) {
        this.pathMemberExtractor = pathMemberExtractor;
        this.isPartial = partial;
    }

    public SyntacticPathExtractor(FeatureExtractor1<TreebankNode> pathMemberExtractor) {
        this(pathMemberExtractor, false);
    }

    public List<Feature> extract(JCas view, TreebankNode leftConstituent, TreebankNode rightConstituent) throws CleartkExtractorException {
        List fromStart = TreebankNodeUtil.getPathToRoot((TreebankNode)leftConstituent);
        List fromEnd = TreebankNodeUtil.getPathToRoot((TreebankNode)rightConstituent);
        String pathFeatureName = null;
        String lengthFeatureName = null;
        fromEnd.remove(fromEnd.size() - 1);
        while (fromStart.size() > 1 && fromEnd.size() > 0 && fromStart.get(fromStart.size() - 2) == fromEnd.get(fromEnd.size() - 1)) {
            fromStart.remove(fromStart.size() - 1);
            fromEnd.remove(fromEnd.size() - 1);
        }
        int length = fromStart.size();
        if (!this.isPartial) {
            length += fromEnd.size();
        }
        try {
            Feature feature;
            ListIterator it = fromStart.listIterator();
            StringBuffer pathBuffer = new StringBuffer();
            boolean first = true;
            while (it.hasNext()) {
                feature = (Feature)this.pathMemberExtractor.extract(view, (Annotation)it.next()).get(0);
                if (first) {
                    String s = feature.getName();
                    if (this.isPartial) {
                        pathFeatureName = Feature.createName((String[])new String[]{this.name, "PartialSyntacticPath(" + s + ")"});
                        lengthFeatureName = Feature.createName((String[])new String[]{this.name, "PartialSyntacticPath", "Length"});
                    } else {
                        pathFeatureName = Feature.createName((String[])new String[]{this.name, "SyntacticPath(" + s + ")"});
                        lengthFeatureName = Feature.createName((String[])new String[]{this.name, "SyntacticPath", "Length"});
                    }
                    first = false;
                } else {
                    pathBuffer.append(this.UP_SEPARATOR);
                }
                pathBuffer.append(feature.getValue().toString());
            }
            if (!this.isPartial) {
                it = fromEnd.listIterator(fromEnd.size());
                while (it.hasPrevious()) {
                    feature = (Feature)this.pathMemberExtractor.extract(view, (Annotation)it.previous()).get(0);
                    pathBuffer.append(this.DOWN_SEPARATOR);
                    pathBuffer.append(feature.getValue().toString());
                }
            }
            ArrayList<Feature> features = new ArrayList<Feature>(2);
            features.add(new Feature(pathFeatureName, (Object)pathBuffer.toString()));
            features.add(new Feature(lengthFeatureName, (Object)length));
            return features;
        }
        catch (IndexOutOfBoundsException e) {
            return new ArrayList<Feature>(0);
        }
    }
}

