/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.feature.syntax;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.NamedFeatureExtractor1;
import org.cleartk.syntax.constituent.type.TreebankNode;

public class SubCategorizationExtractor
implements NamedFeatureExtractor1<TreebankNode> {
    private String featureName;

    public SubCategorizationExtractor(String name) {
        this.featureName = Feature.createName((String[])new String[]{name, "SubCategorization"});
    }

    public SubCategorizationExtractor() {
        this(null);
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public List<Feature> extract(JCas jCas, TreebankNode node) throws UnsupportedOperationException {
        TreebankNode parent = node.getParent();
        if (parent == null) {
            return new ArrayList<Feature>();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(parent.getNodeType() + "->");
        boolean first = true;
        for (TreebankNode child : JCasUtil.select((FSArray)parent.getChildren(), TreebankNode.class)) {
            if (!first) {
                buffer.append("-");
            }
            buffer.append(child.getNodeType());
            first = false;
        }
        return Collections.singletonList(new Feature(this.featureName, (Object)buffer));
    }
}

