/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.bit.user;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.gui.pipeline.bit.parameter.ParameterMapper;
import org.apache.ctakes.gui.pipeline.bit.user.UserBit;
import org.apache.log4j.Logger;
import org.apache.uima.fit.descriptor.ConfigurationParameter;

public final class DefaultUserBit
implements UserBit {
    private static final Logger LOGGER = Logger.getLogger((String)"DefaultUserBit");
    private final PipeBitInfo _pipeBitInfo;
    private final Class<?> _pipeBitClass;
    private String _name;
    private final List<ConfigurationParameter> _parameters;
    private final Map<ConfigurationParameter, String> _typeMap;
    private final Map<ConfigurationParameter, String[]> _parameterValues;

    public DefaultUserBit(PipeBitInfo pipeBitInfo, Class<?> pipeBitClass) {
        this._pipeBitInfo = pipeBitInfo;
        this._pipeBitClass = pipeBitClass;
        this._typeMap = ParameterMapper.createParameterTypeMap(pipeBitClass);
        this._parameterValues = ParameterMapper.createParameterDefaultsMap(pipeBitClass);
        this._parameters = new ArrayList<ConfigurationParameter>(this._typeMap.keySet());
        this._parameters.sort((p1, p2) -> p1.name().compareToIgnoreCase(p2.name()));
    }

    @Override
    public String getBitName() {
        if (this._name == null || this._name.isEmpty()) {
            return this._pipeBitInfo.name();
        }
        return this._name;
    }

    @Override
    public void setBitName(String name) {
        this._name = name;
    }

    @Override
    public PipeBitInfo getPipeBitInfo() {
        return this._pipeBitInfo;
    }

    @Override
    public Class<?> getPipeBitClass() {
        return this._pipeBitClass;
    }

    @Override
    public int getParameterCount() {
        return this._parameters.size();
    }

    @Override
    public ConfigurationParameter getParameter(int index) {
        return this._parameters.get(index);
    }

    @Override
    public String getParameterClass(int index) {
        return this._typeMap.get(this.getParameter(index));
    }

    @Override
    public String getParameterName(int index) {
        return this._parameters.get(index).name();
    }

    @Override
    public String getParameterDescription(int index) {
        return this._parameters.get(index).description();
    }

    @Override
    public boolean isParameterMandatory(int index) {
        return this._parameters.get(index).mandatory();
    }

    @Override
    public String[] getParameterValue(int index) {
        return this._parameterValues.get(this.getParameter(index));
    }

    @Override
    public void setParameterValue(int index, String ... values) {
        this._parameterValues.put(this.getParameter(index), values);
    }
}

