/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.bit.info;

import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.pipeline.PipeBitInfoUtil;

public enum PipeBitInfoComparator implements Comparator<PipeBitInfo>
{
    INSTANCE;

    private static final Map<PipeBitInfo.Role, Integer> ROLE_ORDER;

    public static PipeBitInfoComparator getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(PipeBitInfo info1, PipeBitInfo info2) {
        if (info1.role() != info2.role()) {
            return PipeBitInfoComparator.compareByRole(info1, info2);
        }
        if (PipeBitInfoUtil.isUnknown((PipeBitInfo)info1) != PipeBitInfoUtil.isUnknown((PipeBitInfo)info2)) {
            return PipeBitInfoUtil.isUnknown((PipeBitInfo)info1) ? 1 : -1;
        }
        int depends = PipeBitInfoComparator.compareByDependency(info1, info2);
        if (depends != 0) {
            return depends;
        }
        int usable = PipeBitInfoComparator.compareByMax(info1.usables(), info2.usables());
        if (usable != 0) {
            return usable;
        }
        return info1.name().compareTo(info2.name());
    }

    private static int compareByRole(PipeBitInfo info1, PipeBitInfo info2) {
        return ROLE_ORDER.get(info1.role()) - ROLE_ORDER.get(info2.role());
    }

    private static int compareByMax(PipeBitInfo.TypeProduct[] types1, PipeBitInfo.TypeProduct[] types2) {
        int max1 = Arrays.stream(types1).mapToInt(Enum::ordinal).max().orElse(0);
        int max2 = Arrays.stream(types2).mapToInt(Enum::ordinal).max().orElse(0);
        return max1 - max2;
    }

    private static int compareBySum(PipeBitInfo.TypeProduct[] types1, PipeBitInfo.TypeProduct[] types2) {
        int sum1 = Arrays.stream(types1).mapToInt(Enum::ordinal).sum();
        int sum2 = Arrays.stream(types2).mapToInt(Enum::ordinal).sum();
        return sum1 - sum2;
    }

    private static int compareByDependency(PipeBitInfo info1, PipeBitInfo info2) {
        int dependMax = PipeBitInfoComparator.compareByMax(info1.dependencies(), info2.dependencies());
        if (dependMax != 0) {
            return dependMax;
        }
        int produceMax = PipeBitInfoComparator.compareByMax(info1.products(), info2.products());
        if (produceMax != 0) {
            return produceMax;
        }
        int dependSum = PipeBitInfoComparator.compareBySum(info1.dependencies(), info2.dependencies());
        if (dependSum != 0) {
            return dependSum;
        }
        int produceSum = PipeBitInfoComparator.compareBySum(info1.products(), info2.products());
        if (produceSum != 0) {
            return produceSum;
        }
        if (info1.dependencies().length != info2.dependencies().length) {
            return info1.dependencies().length - info2.dependencies().length;
        }
        return info1.products().length - info2.products().length;
    }

    static {
        ROLE_ORDER = new EnumMap<PipeBitInfo.Role, Integer>(PipeBitInfo.Role.class);
        ROLE_ORDER.put(PipeBitInfo.Role.READER, 1);
        ROLE_ORDER.put(PipeBitInfo.Role.ANNOTATOR, 2);
        ROLE_ORDER.put(PipeBitInfo.Role.WRITER, 3);
        ROLE_ORDER.put(PipeBitInfo.Role.SPECIAL, 4);
    }
}

