/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.dictionary;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.ctakes.gui.component.DisablerPane;
import org.apache.ctakes.gui.dictionary.MainPanel;
import org.apache.log4j.Logger;

public final class DictionaryCreator {
    private static final Logger LOGGER = Logger.getLogger(DictionaryCreator.class);

    private DictionaryCreator() {
    }

    private static JFrame createFrame() {
        JFrame frame = new JFrame("cTAKES Dictionary Creator");
        frame.setDefaultCloseOperation(3);
        Dimension size = new Dimension(800, 600);
        frame.setSize(size);
        frame.setMinimumSize(size);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        frame.setJMenuBar(menuBar);
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        return frame;
    }

    private static JComponent createMainPanel() {
        return new MainPanel();
    }

    public static void main(String ... args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            UIManager.getDefaults().put("SplitPane.border", BorderFactory.createEmptyBorder());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException multE) {
            LOGGER.error((Object)multE.getLocalizedMessage());
        }
        JFrame frame = DictionaryCreator.createFrame();
        JComponent mainPanel = DictionaryCreator.createMainPanel();
        frame.add(mainPanel);
        frame.pack();
        frame.setVisible(true);
        DisablerPane.getInstance().initialize(frame);
        LOGGER.info((Object)"1. Select your Apache cTAKES root directory.");
        LOGGER.info((Object)"   It can be a pre-built binary installation or a developer sandbox.");
        LOGGER.info((Object)"2. Select your Unified Medical Language System (UMLS) root directory.");
        LOGGER.info((Object)"   Once selected, your UMLS database will be parsed for available content.");
        LOGGER.info((Object)"3. Select your desired Vocabulary sources in the left table.");
        LOGGER.info((Object)"   Recommended Vocabulary sources are pre-selected.");
        LOGGER.info((Object)"4. Select your desired Semantic Types in the right table.");
        LOGGER.info((Object)"   Recommended Semantic types are pre-selected.");
        LOGGER.info((Object)"5. Type a name for your dictionary.");
        LOGGER.info((Object)"6. Click 'Build Dictionary'");
        LOGGER.info((Object)"-  You can resize this log panel by clicking the top and dragging up or down.");
    }
}

