/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.component;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.annotation.concurrent.NotThreadSafe;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public final class SystemOutPanel
extends JScrollPane {
    private static final Logger LOGGER = Logger.getLogger((String)"SystemOutPanel");
    private final boolean _isStandardOutRedirect;
    private final Document _textAreaDoc = new PlainDocument();
    private PrintStream _oldStandardStream;

    public SystemOutPanel() {
        this(true);
    }

    public SystemOutPanel(boolean isStandardOutRedirect) {
        this._isStandardOutRedirect = isStandardOutRedirect;
        JTextArea textArea = new JTextArea(this._textAreaDoc);
        textArea.setEditable(false);
        super.setViewportView(textArea);
    }

    public void startRedirect() {
        PrintStream newStandardStream = new PrintStream(new UiOutputStream());
        this.clearText();
        if (this._isStandardOutRedirect) {
            this._oldStandardStream = System.out;
            System.setOut(newStandardStream);
        } else {
            this._oldStandardStream = System.err;
            System.setErr(newStandardStream);
        }
    }

    public void endRedirect() {
        if (this._isStandardOutRedirect) {
            System.setOut(this._oldStandardStream);
        } else {
            System.setErr(this._oldStandardStream);
        }
    }

    public String getText() {
        try {
            return this._textAreaDoc.getText(0, this._textAreaDoc.getLength());
        }
        catch (BadLocationException blE) {
            return "";
        }
    }

    public void clearText() {
        SwingUtilities.invokeLater(() -> {
            try {
                this._textAreaDoc.remove(0, this._textAreaDoc.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        });
    }

    public void appendText(String text) {
        SwingUtilities.invokeLater(() -> {
            try {
                this._textAreaDoc.insertString(this._textAreaDoc.getLength(), text, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        });
    }

    @NotThreadSafe
    private class UiOutputStream
    extends OutputStream {
        private final StringBuilder __sb = new StringBuilder();

        private UiOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.__sb.append((char)b);
            if ((char)b == '\n') {
                SystemOutPanel.this.appendText(this.__sb.toString());
                this.__sb.setLength(0);
            }
        }

        @Override
        public void flush() throws IOException {
            SystemOutPanel.this.appendText(this.__sb.toString());
            this.__sb.setLength(0);
            super.flush();
        }

        @Override
        public void close() throws IOException {
            SystemOutPanel.this.appendText(this.__sb.toString());
            this.__sb.setLength(0);
            super.close();
        }
    }
}

