/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.nn.data;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.ctakes.temporal.duration.Utils;
import org.apache.ctakes.temporal.eval.CommandLine;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.temporal.nn.data.ArgContextProvider;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class EventTimeRelPrinter {
    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        File trainFile = options.getTrainOutputDirectory();
        if (trainFile.exists()) {
            trainFile.delete();
        }
        trainFile.createNewFile();
        File devFile = options.getTestOutputDirectory();
        if (devFile.exists()) {
            devFile.delete();
        }
        devFile.createNewFile();
        List<Integer> patientSets = options.getPatients().getList();
        List<Integer> trainItems = THYMEData.getPatientSets(patientSets, THYMEData.TRAIN_REMAINDERS);
        List<Integer> devItems = THYMEData.getPatientSets(patientSets, THYMEData.DEV_REMAINDERS);
        List<File> trainFiles = Utils.getFilesFor(trainItems, options.getInputDirectory());
        List<File> devFiles = Utils.getFilesFor(devItems, options.getInputDirectory());
        Collections.sort(trainFiles);
        CollectionReader trainCollectionReader = Utils.getCollectionReader(trainFiles);
        AnalysisEngine trainDataWriter = AnalysisEngineFactory.createEngine(RelationSnippetPrinter.class, (Object[])new Object[]{"IsTraining", true, "OutputFile", trainFile.getAbsoluteFile()});
        SimplePipeline.runPipeline((CollectionReader)trainCollectionReader, (AnalysisEngine[])new AnalysisEngine[]{trainDataWriter});
        CollectionReader devCollectionReader = Utils.getCollectionReader(devFiles);
        AnalysisEngine devDataWriter = AnalysisEngineFactory.createEngine(RelationSnippetPrinter.class, (Object[])new Object[]{"IsTraining", false, "OutputFile", devFile.getAbsolutePath()});
        SimplePipeline.runPipeline((CollectionReader)devCollectionReader, (AnalysisEngine[])new AnalysisEngine[]{devDataWriter});
    }

    public static class RelationSnippetPrinter
    extends JCasAnnotator_ImplBase {
        @ConfigurationParameter(name="IsTraining", mandatory=true, description="are we training?")
        private boolean isTraining;
        @ConfigurationParameter(name="OutputFile", mandatory=true, description="path to the output file")
        private String outputFile;

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            Object arg2;
            Annotation arg1;
            JCas systemView;
            JCas goldView;
            try {
                goldView = jCas.getView("GoldView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            try {
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            HashMap<List<Annotation>, BinaryTextRelation> relationLookup = new HashMap<List<Annotation>, BinaryTextRelation>();
            if (this.isTraining) {
                for (BinaryTextRelation relation : JCasUtil.select((JCas)goldView, TemporalTextRelation.class)) {
                    arg1 = relation.getArg1().getArgument();
                    if (relationLookup.get(Arrays.asList(arg1, arg2 = relation.getArg2().getArgument())) != null) {
                        if (relation.getCategory().equals("CONTAINS")) {
                            relationLookup.put(Arrays.asList(arg1, arg2), relation);
                            continue;
                        }
                        System.out.println("skipping relation: " + arg1.getCoveredText() + " ... " + arg2.getCoveredText());
                        continue;
                    }
                    relationLookup.put(Arrays.asList(arg1, arg2), relation);
                }
            } else {
                for (BinaryTextRelation relation : JCasUtil.select((JCas)goldView, TemporalTextRelation.class)) {
                    arg1 = relation.getArg1().getArgument();
                    arg2 = relation.getArg2().getArgument();
                    relationLookup.put(Arrays.asList(arg1, arg2), relation);
                }
            }
            for (Sentence sentence : JCasUtil.select((JCas)systemView, Sentence.class)) {
                ArrayList<String> eventTimeRelationsInSentence = new ArrayList<String>();
                for (EventMention event : JCasUtil.selectCovered((JCas)goldView, EventMention.class, (AnnotationFS)sentence)) {
                    for (TimeMention time : JCasUtil.selectCovered((JCas)goldView, TimeMention.class, (AnnotationFS)sentence)) {
                        BinaryTextRelation timeEventRelation = (BinaryTextRelation)relationLookup.get(Arrays.asList(time, event));
                        BinaryTextRelation eventTimeRelation = (BinaryTextRelation)relationLookup.get(Arrays.asList(event, time));
                        String label = "none";
                        if (timeEventRelation != null && timeEventRelation.getCategory().equals("CONTAINS")) {
                            label = "contains";
                        }
                        if (eventTimeRelation != null && eventTimeRelation.getCategory().equals("CONTAINS")) {
                            label = "contains-1";
                        }
                        String context = time.getBegin() < event.getBegin() ? ArgContextProvider.getTokenContext(systemView, sentence, (Annotation)time, "t", (Annotation)event, "e", 2) : ArgContextProvider.getTokenContext(systemView, sentence, (Annotation)event, "e", (Annotation)time, "t", 2);
                        String text = String.format("%s|%s", label, context);
                        eventTimeRelationsInSentence.add(text.toLowerCase());
                    }
                }
                try {
                    Files.write(Paths.get(this.outputFile, new String[0]), eventTimeRelationsInSentence, StandardOpenOption.APPEND);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static interface Options {
        @Option(longName={"xmi-dir"})
        public File getInputDirectory();

        @Option(longName={"patients"})
        public CommandLine.IntegerRanges getPatients();

        @Option(longName={"output-train"})
        public File getTrainOutputDirectory();

        @Option(longName={"output-test"})
        public File getTestOutputDirectory();
    }
}

