/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.eval;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.lexicalscope.jewel.cli.CliFactory;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.ctakes.relationextractor.eval.RelationExtractorEvaluation;
import org.apache.ctakes.temporal.ae.EventEventRelationAnnotator;
import org.apache.ctakes.temporal.eval.EvaluationOfEventTimeRelations;
import org.apache.ctakes.temporal.eval.EvaluationOfTemporalRelations_ImplBase;
import org.apache.ctakes.temporal.eval.Evaluation_ImplBase;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.testing.util.HideOutput;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.ml.jar.JarClassifierBuilder;
import org.cleartk.ml.libsvm.LibSvmStringOutcomeDataWriter;
import org.cleartk.util.ViewUriUtil;

public class EvaluationOfEventEventRelations
extends EvaluationOfTemporalRelations_ImplBase {
    private boolean baseline = false;

    public EvaluationOfEventEventRelations(File baseDirectory, File rawTextDirectory, File xmlDirectory, Evaluation_ImplBase.XMLFormat xmlFormat, Evaluation_ImplBase.Subcorpus subcorpus, File xmiDirectory, File treebankDirectory, boolean printErrors, boolean printRelations, boolean baseline, EvaluationOfEventTimeRelations.ParameterSettings params) {
        super(baseDirectory, rawTextDirectory, xmlDirectory, xmlFormat, subcorpus, xmiDirectory, treebankDirectory, printErrors, printRelations, params);
        this.baseline = baseline;
    }

    protected void train(CollectionReader collectionReader, File directory) throws Exception {
        AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(Evaluation_ImplBase.CopyFromGold.getDescription(EventMention.class, TimeMention.class, BinaryTextRelation.class), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfTemporalRelations_ImplBase.RemoveNonContainsRelations.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfEventTimeRelations.RemoveCrossSentenceRelations.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfTemporalRelations_ImplBase.PreserveEventEventRelations.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(EventEventRelationAnnotator.createDataWriterDescription(LibSvmStringOutcomeDataWriter.class, directory, 1.0), new String[0]);
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        HideOutput hider = new HideOutput();
        JarClassifierBuilder.trainAndPackage((File)directory, (String[])new String[]{"-t", "0", "-c", "10"});
        hider.restoreOutput();
    }

    protected AnnotationStatistics<String> test(CollectionReader collectionReader, File directory) throws Exception {
        AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(Evaluation_ImplBase.CopyFromGold.getDescription(EventMention.class, TimeMention.class), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfTemporalRelations_ImplBase.RemoveNonContainsRelations.class, (Object[])new Object[0]), new String[]{"_InitialView", "GoldView"});
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfEventTimeRelations.RemoveCrossSentenceRelations.class, (Object[])new Object[]{"SentenceView", "_InitialView", "RelationView", "GoldView"}), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfTemporalRelations_ImplBase.PreserveEventEventRelations.class, (Object[])new Object[0]), new String[]{"_InitialView", "GoldView"});
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfEventTimeRelations.RemoveRelations.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(EventEventRelationAnnotator.createAnnotatorDescription(directory), new String[0]);
        Function<BinaryTextRelation, RelationExtractorEvaluation.HashableArguments> getSpan = new Function<BinaryTextRelation, RelationExtractorEvaluation.HashableArguments>(){

            public RelationExtractorEvaluation.HashableArguments apply(BinaryTextRelation relation) {
                return new RelationExtractorEvaluation.HashableArguments(relation);
            }
        };
        Function getOutcome = AnnotationStatistics.annotationToFeatureValue((String)"category");
        AnnotationStatistics stats = new AnnotationStatistics();
        JCasIterator casIter = new JCasIterator(collectionReader, new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        while (casIter.hasNext()) {
            Object relation2;
            JCas jCas = (JCas)casIter.next();
            JCas goldView = jCas.getView("GoldView");
            JCas systemView = jCas.getView("_InitialView");
            Collection goldRelations = JCasUtil.select((JCas)goldView, BinaryTextRelation.class);
            Collection systemRelations = JCasUtil.select((JCas)systemView, BinaryTextRelation.class);
            stats.add(goldRelations, systemRelations, (Function)getSpan, getOutcome);
            if (this.printRelations) {
                URI uri = ViewUriUtil.getURI((JCas)jCas);
                String[] path = uri.getPath().split("/");
                EvaluationOfEventEventRelations.printRelationAnnotations((String)path[path.length - 1], systemRelations);
            }
            if (!this.printErrors) continue;
            HashMap goldMap = Maps.newHashMap();
            for (Object relation2 : goldRelations) {
                goldMap.put(new RelationExtractorEvaluation.HashableArguments((BinaryTextRelation)relation2), relation2);
            }
            HashMap systemMap = Maps.newHashMap();
            relation2 = systemRelations.iterator();
            while (relation2.hasNext()) {
                BinaryTextRelation relation3 = (BinaryTextRelation)relation2.next();
                systemMap.put(new RelationExtractorEvaluation.HashableArguments(relation3), relation3);
            }
            Sets.SetView all = Sets.union(goldMap.keySet(), systemMap.keySet());
            ArrayList sorted = Lists.newArrayList((Iterable)all);
            Collections.sort(sorted);
            for (RelationExtractorEvaluation.HashableArguments key : sorted) {
                BinaryTextRelation goldRelation = (BinaryTextRelation)goldMap.get(key);
                BinaryTextRelation systemRelation = (BinaryTextRelation)systemMap.get(key);
                if (goldRelation == null) {
                    System.out.println("System added: " + EvaluationOfEventEventRelations.formatRelation(systemRelation));
                    continue;
                }
                if (systemRelation == null) {
                    System.out.println("System dropped: " + EvaluationOfEventEventRelations.formatRelation(goldRelation));
                    continue;
                }
                if (!systemRelation.getCategory().equals(goldRelation.getCategory())) {
                    String label = systemRelation.getCategory();
                    System.out.printf("System labeled %s for %s\n", label, EvaluationOfEventEventRelations.formatRelation(goldRelation));
                    continue;
                }
                System.out.println("Nailed it! " + EvaluationOfEventEventRelations.formatRelation(systemRelation));
            }
        }
        return stats;
    }

    public static void main(String[] args) throws Exception {
        EvaluationOfTemporalRelations_ImplBase.TempRelOptions options = (EvaluationOfTemporalRelations_ImplBase.TempRelOptions)CliFactory.parseArguments(EvaluationOfTemporalRelations_ImplBase.TempRelOptions.class, (String[])args);
        List<Integer> patientSets = options.getPatients().getList();
        List<Integer> trainItems = EvaluationOfEventEventRelations.getTrainItems(options);
        List<Integer> testItems = EvaluationOfEventEventRelations.getTestItems(options);
        File workingDir = new File("target/eval/temporal-relations/event-event/");
        EvaluationOfEventTimeRelations.ParameterSettings params = defaultParams;
        EvaluationOfEventEventRelations evaluation = new EvaluationOfEventEventRelations(workingDir, options.getRawTextDirectory(), options.getXMLDirectory(), options.getXMLFormat(), options.getSubcorpus(), options.getXMIDirectory(), options.getTreebankDirectory(), options.getPrintErrors(), options.getPrintFormattedRelations(), options.getBaseline(), params);
        evaluation.prepareXMIsFor(patientSets);
        AnnotationStatistics stats = (AnnotationStatistics)evaluation.trainAndTest(trainItems, testItems);
        System.err.println(stats);
    }
}

