/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class NumberOfEventsInTheSameSentenceExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        Map coveringMap = JCasUtil.indexCovering((JCas)jCas, IdentifiedAnnotation.class, Sentence.class);
        Collection sentList = (Collection)coveringMap.get(arg1);
        if (sentList == null && sentList.isEmpty()) {
            return feats;
        }
        for (Sentence sent : sentList) {
            List events = JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)sent);
            ArrayList realEvents = Lists.newArrayList();
            for (EventMention event : events) {
                if (!event.getClass().equals(EventMention.class)) continue;
                realEvents.add(event);
            }
            events = realEvents;
            int eventsNum = events == null ? 0 : events.size();
            int arg1Index = -1;
            int arg2Index = -1;
            for (int i = 0; i < eventsNum; ++i) {
                EventMention currentEvent = (EventMention)events.get(i);
                if (NumberOfEventsInTheSameSentenceExtractor.hasOverlappingSpan(currentEvent, arg1)) {
                    arg1Index = i;
                }
                if (NumberOfEventsInTheSameSentenceExtractor.hasOverlappingSpan(currentEvent, arg2)) {
                    arg2Index = i;
                }
                if (arg1Index != -1 && arg2Index != -1) break;
            }
            if (arg1Index != -1 && arg2Index != -1) {
                int dis = Math.abs(arg1Index - arg2Index);
                feats.add(new Feature("EventPair_Distance", (Object)dis));
                if (dis == eventsNum - 1) {
                    feats.add(new Feature("EventPair_", (Object)"Major"));
                }
                if (dis != 1) continue;
                feats.add(new Feature("EventPair_", (Object)"Consecutive"));
                continue;
            }
            System.out.println("Same sentence events matching error.");
        }
        return feats;
    }

    private static boolean hasOverlappingSpan(EventMention cevent, IdentifiedAnnotation arg) {
        if (cevent.getBegin() == arg.getBegin() || arg.getEnd() == cevent.getEnd()) {
            return true;
        }
        if (arg.getBegin() <= cevent.getBegin() && cevent.getEnd() >= arg.getEnd()) {
            return true;
        }
        return arg.getBegin() >= cevent.getBegin() && cevent.getEnd() <= arg.getEnd();
    }
}

