/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.DependencyParseUtils;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class DependingVerbsFeatureExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    private static final String FEAT_NAME = "Depending_Verb";

    public List<Feature> extract(JCas jcas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        ConllDependencyNode ancestor = null;
        boolean hasCommonVerb = false;
        block0: for (ConllDependencyNode firstNode : JCasUtil.selectCovered((JCas)jcas, ConllDependencyNode.class, (AnnotationFS)arg1)) {
            String pos = firstNode.getPostag();
            if (pos == null || !pos.startsWith("NN")) continue;
            for (ConllDependencyNode nextNode : JCasUtil.selectCovered((JCas)jcas, ConllDependencyNode.class, (AnnotationFS)arg2)) {
                pos = nextNode.getPostag();
                if (pos == null || !pos.startsWith("NN") || (ancestor = DependencyParseUtils.getCommonAncestor(firstNode, nextNode)) == null || !ancestor.getPostag().startsWith("VB")) continue;
                features.add(new Feature(FEAT_NAME, (Object)"both_events_governed_by_the_same_verb"));
                features.add(new Feature(FEAT_NAME, (Object)(ancestor.getDeprel() + "_" + ancestor.getCoveredText().toLowerCase())));
                hasCommonVerb = true;
                break block0;
            }
        }
        if (!hasCommonVerb) {
            features.addAll(DependingVerbsFeatureExtractor.getDependingVerbFeature(jcas, arg1));
            features.addAll(DependingVerbsFeatureExtractor.getDependingVerbFeature(jcas, arg2));
        }
        return features;
    }

    private static List<Feature> getDependingVerbFeature(JCas jcas, IdentifiedAnnotation arg) {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        for (ConllDependencyNode dnode : JCasUtil.selectCovered((JCas)jcas, ConllDependencyNode.class, (AnnotationFS)arg)) {
            EventMention mention;
            ConllDependencyNode verbNode;
            String pos = dnode.getPostag();
            if (pos == null || !pos.startsWith("NN") || (verbNode = DependingVerbsFeatureExtractor.getVerbAncestor(dnode)) == null) continue;
            Integer typeId = -1;
            if (arg instanceof EventMention && (mention = (EventMention)arg).getEvent() != null && mention.getEvent().getProperties() != null) {
                typeId = mention.getEvent().getProperties().getTypeIndexID();
            }
            feats.add(new Feature(FEAT_NAME, (Object)(typeId + "_" + verbNode.getPostag())));
            String depRelation = dnode.getDeprel();
            if (depRelation.startsWith("nsubj")) {
                feats.add(new Feature(FEAT_NAME, (Object)(typeId + "_isASubject")));
                break;
            }
            if (!depRelation.startsWith("dobj")) break;
            feats.add(new Feature(FEAT_NAME, (Object)(typeId + "_isAnObject")));
            break;
        }
        return feats;
    }

    private static ConllDependencyNode getVerbAncestor(ConllDependencyNode dnode) {
        ConllDependencyNode verbNode = null;
        ConllDependencyNode currNode = dnode;
        while (currNode != null && currNode.getHead() != null) {
            String nodepos = (currNode = currNode.getHead()) == null ? null : currNode.getPostag();
            if (nodepos == null || !nodepos.startsWith("VB")) continue;
            verbNode = currNode;
            return verbNode;
        }
        return verbNode;
    }
}

